/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccPersonRemote;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonService;
import com.zkteco.zkbiosecurity.acc.vo.AccLevelItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonListItem;
import com.zkteco.zkbiosecurity.acc.vo.AccSelectPersonItem;
import com.zkteco.zkbiosecurity.acc.vo.AccSelectPersonRadioItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.service.PersUserTypeService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.pers.vo.PersUserTypeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccPersonController
extends BaseController
implements AccPersonRemote {
    @Autowired
    private AccPersonService accPersonService;
    @Autowired
    private AccLevelService accLevelService;
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    PersUserTypeService persUserTypeService;

    @RequiresPermissions(value={"pers:person:accEdit"})
    public ModelAndView edit(@RequestParam(value="personId", required=false) String personId) {
        PersPersonItem person;
        AccLevelItem masterLevel;
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            this.request.setAttribute("item", (Object)this.accPersonService.getItemByPersonId(personId));
            this.request.setAttribute("tempList", (Object)this.accLevelService.getLevelByPersonId(personId));
        }
        if (Objects.nonNull(masterLevel = this.accLevelService.getMasterLevel())) {
            this.request.setAttribute("defaultLevel", (Object)masterLevel);
        }
        if (Objects.nonNull(person = this.persPersonService.getItemById(personId))) {
            this.request.setAttribute("membershipId", (Object)person.getMembershipId());
            this.request.setAttribute("gracePeriod", (Object)person.getGracePeriod());
            PersUserTypeItem userType = this.persUserTypeService.getItemById(person.getUserTypeId());
            if (Objects.nonNull(userType)) {
                this.request.setAttribute("userType", (Object)userType.getUserTypeName());
            }
        }
        return new ModelAndView("acc/person/editAccPerson");
    }

    @RequiresPermissions(value={"acc:personLevelByPerson:setAccParams"})
    @LogRequest(module="acc_module", object="common_leftMenu_levelSetByPerson", opType="pers_person_accSetting", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg saveParamSet(AccPersonItem item, String ids) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                item.setPersonId(id);
                item.setDisabled(Boolean.valueOf(item.getDisabled() == null ? false : item.getDisabled()));
                this.accPersonService.saveParamSet(item);
                ++n2;
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getPersonCountByDept(String deptIds) {
        long personCount = this.accPersonService.getPersonCountByDept(deptIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)personCount));
    }

    @RequiresPermissions(value={"acc:globalLinkage:refresh"})
    public DxGrid getGlobalLinkagePerson(AccPersonListItem codition) {
        codition.setModelType("ACC_GLOBALLINKAGE");
        Pager pager = this.accPersonService.getPersonItemList(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ModelAndView filterPersonByVaildCard(String cardNo) {
        Map filterPersonMap = this.accPersonService.filterPersonByVaildCard(cardNo);
        if ("true".equals(filterPersonMap.get("cardNoExist"))) {
            this.request.setAttribute("personPin", filterPersonMap.get("personPin"));
            return new ModelAndView("acc/rtMonitor/opAccSetCardNoToPerson");
        }
        this.request.setAttribute("cardNo", (Object)cardNo);
        return new ModelAndView("acc/rtMonitor/opAccSelectNoCardPersonContent");
    }

    public DxGrid getNoCardPerson(AccSelectPersonRadioItem accSelectPersonRadioItem) {
        Pager pager = new Pager();
        if (accSelectPersonRadioItem.getType().equals("noSelected")) {
            pager = this.accPersonService.getNoCardPerson(this.request.getSession().getId(), accSelectPersonRadioItem, this.getPageNo(), this.getPageSize());
        } else if (accSelectPersonRadioItem.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, accSelectPersonRadioItem.getClass());
    }

    public DxGrid selectPersonlist(AccSelectPersonItem codition) {
        Pager pager = new Pager();
        if (codition.getType().equals("noSelected")) {
            pager = this.accPersonService.getNoExistPerson(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        } else if (codition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg setPersonCard(String personId, String cardNo) {
        this.accPersonService.setCardNoToPerson(personId, cardNo);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView getAllField(@RequestParam(value="cardNo", required=false) String cardNo) {
        this.request.setAttribute("cardNo", (Object)cardNo);
        this.request.setAttribute("editPage", (Object)true);
        if ("zh_CN".equals(LocaleMessageSourceUtil.language)) {
            return new ModelAndView("pers/person/editPersPersonZH");
        }
        this.request.setAttribute("showSMS", (Object)this.accPersonService.checkShowSMS());
        return new ModelAndView("pers/person/editPersPerson");
    }

    public DxGrid selectLevelPersonList(AccSelectPersonItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            pager = this.accPersonService.getNoExistLevelPerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

