/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.remote.AccLinkageRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceEventService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceOptionService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccLinkageService;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceEventItem;
import com.zkteco.zkbiosecurity.acc.vo.AccLinkageBeanItem;
import com.zkteco.zkbiosecurity.acc.vo.AccLinkageItem;
import com.zkteco.zkbiosecurity.acc.vo.AccLinkageSelectContactItem;
import com.zkteco.zkbiosecurity.acc.vo.AccLinkageSelectDeviceItem;
import com.zkteco.zkbiosecurity.acc.vo.AccLinkageSelectIasPartitionItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccLinkageController
extends BaseController
implements AccLinkageRemote {
    private static final Logger log = LoggerFactory.getLogger(AccLinkageController.class);
    @Autowired
    private AccLinkageService accLinkageService;
    @Autowired
    private AccDeviceOptionService accDeviceOptionService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccDeviceEventService accDeviceEventService;

    @RequiresPermissions(value={"acc:linkage"})
    public ModelAndView index() {
        return new ModelAndView("acc/linkage/accLinkage");
    }

    @RequiresPermissions(value={"acc:linkage:add", "acc:linkage:edit"})
    public ModelAndView edit(String id) {
        boolean showLine = this.accLinkageService.checkShowLine();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AccLinkageItem accLinkageItem = this.accLinkageService.getLinkageParams(id);
            this.request.setAttribute("item", (Object)accLinkageItem);
            if (showLine) {
                List accLinkage4LineContactItems = this.accLinkageService.getLineContactsByIds(accLinkageItem.getLineContactId());
                this.request.setAttribute("contactList", (Object)accLinkage4LineContactItems);
            }
        }
        this.request.setAttribute("showLine", (Object)showLine);
        this.request.setAttribute("showWhatsapp", (Object)this.accLinkageService.checkShowWhatsapp());
        this.request.setAttribute("showSMS", (Object)this.accLinkageService.checkShowSMS());
        this.request.setAttribute("showDigifort", (Object)this.accLinkageService.checkShowDigifort());
        return new ModelAndView("acc/linkage/editAccLinkage");
    }

    @RequiresPermissions(value={"acc:linkage:add", "acc:linkage:edit"})
    @LogRequest(module="acc_module", object="acc_dev_linkage", opType="common_op_edit", requestParams={"name"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg save(AccLinkageItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String[] inputsAddr = this.request.getParameter("inputAddr").split(",");
        String outputDoor = this.request.getParameter("outputDoorAddr");
        String outputAuxOut = this.request.getParameter("outputAuxOutAddr");
        String[] outputDoorAddr = "".equals(outputDoor) ? new String[]{} : outputDoor.split(",");
        String[] outputAuxOutAddr = "".equals(outputAuxOut) ? new String[]{} : outputAuxOut.split(",");
        String[] outputsAddr = new String[outputDoorAddr.length + outputAuxOutAddr.length];
        System.arraycopy(outputDoorAddr, 0, outputsAddr, 0, outputDoorAddr.length);
        System.arraycopy(outputAuxOutAddr, 0, outputsAddr, outputDoorAddr.length, outputAuxOutAddr.length);
        String[] triggerCondArray = this.request.getParameter("triggerCond").split(",");
        short doorActionType = Short.parseShort(this.request.getParameter("doorActionType"));
        short doorActionTime = Short.parseShort(this.request.getParameter("doorActionTime"));
        short auxoutActionType = Short.parseShort(this.request.getParameter("auxoutActionType"));
        short auxoutActionTime = Short.parseShort(this.request.getParameter("auxoutActionTime"));
        String[] mailAddr = this.request.getParameter("mailAddr").replaceAll(";", ",").split(",");
        String[] mobileNo = null;
        if (StringUtils.isNotBlank((CharSequence)this.request.getParameter("mobileNo"))) {
            mobileNo = this.request.getParameter("mobileNo").replaceAll(";", ",").split(",");
        }
        String[] whatsappMobileNo = null;
        if (StringUtils.isNotBlank((CharSequence)item.getWhatsappMobileNo())) {
            whatsappMobileNo = item.getWhatsappMobileNo().replaceAll(";", ",").split(",");
        }
        String[] partitionIdArray = StringUtils.isBlank((CharSequence)item.getIasPartitionIds()) ? new String[]{} : item.getIasPartitionIds().split(",");
        String popUpVideo = this.request.getParameter("popUpVideo");
        String popUpTime = this.request.getParameter("popUpTime");
        String record = this.request.getParameter("record");
        String recordTime = this.request.getParameter("recordTime");
        String capture = this.request.getParameter("capture");
        String captureTime = this.request.getParameter("captureTime");
        String digiEventNames = this.request.getParameter("digiEventNames");
        String lineContactIds = this.request.getParameter("lineContactId");
        AccLinkageBeanItem accLinkageBean = new AccLinkageBeanItem();
        accLinkageBean.setInputsAddr(inputsAddr);
        accLinkageBean.setOutputsAddr(outputsAddr);
        accLinkageBean.setTriggerCondArray(triggerCondArray);
        accLinkageBean.setDoorActionType(doorActionType);
        accLinkageBean.setDoorActionTime(doorActionTime);
        accLinkageBean.setAuxoutActionType(auxoutActionType);
        accLinkageBean.setAuxoutActionTime(auxoutActionTime);
        accLinkageBean.setMailAddr(mailAddr);
        accLinkageBean.setMobileNo(mobileNo);
        accLinkageBean.setLineContactIds(lineContactIds);
        accLinkageBean.setWhatsappMobileNo(whatsappMobileNo);
        accLinkageBean.setPartitionActionType(item.getPartitionActionType());
        accLinkageBean.setIasPartitionIds(partitionIdArray);
        accLinkageBean.setIasManufacture(item.getIasManufacture());
        accLinkageBean.setPartitionArmType(item.getPartitionArmType());
        if (StringUtils.isNotBlank((CharSequence)popUpVideo) && "1".equals(popUpVideo)) {
            accLinkageBean.setPopUpTime(Integer.valueOf(Integer.parseInt(popUpTime)));
        }
        if (StringUtils.isNotBlank((CharSequence)record) && "2".equals(record)) {
            accLinkageBean.setRecordTime(Integer.valueOf(Integer.parseInt(recordTime)));
        }
        if (StringUtils.isNotBlank((CharSequence)capture) && "3".equals(capture)) {
            accLinkageBean.setCapture(capture);
            if (StringUtils.isNotBlank((CharSequence)captureTime)) {
                accLinkageBean.setCaptureTime(Integer.valueOf(Integer.parseInt(captureTime)));
            } else {
                accLinkageBean.setCaptureTime(Integer.valueOf(0));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)digiEventNames)) {
            accLinkageBean.setDigiEventNames(digiEventNames);
        }
        this.accLinkageService.saveItem(accLinkageBean, item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:linkage:refresh"})
    public DxGrid list(AccLinkageItem codition) {
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.accLinkageService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        List accLinkageItemList = pager.getData();
        accLinkageItemList.forEach(accLinkageItem -> {
            List triggerCondList = this.accLinkageService.getTriggerCondByLinkId(accLinkageItem.getId());
            StringBuilder triggerStr = new StringBuilder();
            triggerCondList.forEach(triggerCond -> triggerStr.append(String.valueOf(I18nUtil.i18nCode((String)triggerCond, (Object[])new Object[0])) + ","));
            accLinkageItem.setTriggerCond(triggerStr.toString().substring(0, triggerStr.length() - 1));
        });
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:linkage:del"})
    @LogRequest(module="acc_module", object="acc_dev_linkage", opType="common_op_del", requestParams={"names"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg del(String ids) {
        this.accLinkageService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getAllFilterId() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String idStr = this.accLinkageService.getAllFilterId();
        zkResultMsg.setData((Object)idStr);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg checkTriggerOpt() {
        String devId = this.request.getParameter("devId");
        String triggerOpt = this.request.getParameter("triggerOpt");
        String[] triggerCondArray = new String[]{};
        if (triggerOpt.length() > 0) {
            triggerCondArray = this.request.getParameter("triggerOpt").split(",");
        }
        String[] inAddrArray = this.request.getParameter("inAddr").split(",");
        String linkageId = this.request.getParameter("linkageId");
        ZKResultMsg zkResultMsg = this.accLinkageService.checkTriggerOpt(devId, triggerCondArray, inAddrArray, linkageId);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg checkMailParam() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.accLinkageService.completeMailInfo());
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg isSupportLockDoor(String devId) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.accDeviceOptionService.getAccSupportFunListVal(devId, 2));
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public String valid(String name) {
        AccLinkageItem item = this.accLinkageService.getItemByName(name);
        return String.valueOf(item == null);
    }

    public ZKResultMsg getLinkTriggerOpt() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String deviceId = this.request.getParameter("devId");
        String accLinkageId = this.request.getParameter("accLinkageId");
        Map triggerOptMap = this.accLinkageService.getLinkTriggerOpt(deviceId, accLinkageId);
        List eventList = (List)triggerOptMap.get("eventList");
        Map checkEventMap = (Map)triggerOptMap.get("checkEventMap");
        Map checkParentElementMap = (Map)triggerOptMap.get("checkParentElementMap");
        JSONArray triggerOptArray = new JSONArray();
        try {
            JSONArray deviceEvent = new JSONArray();
            JSONArray auxInEvent = new JSONArray();
            JSONArray doorEvent = new JSONArray();
            JSONObject dataJson = null;
            for (AccDeviceEventItem event : eventList) {
                short eventNo = event.getEventNo();
                if (this.accDeviceEventService.isLinkTriggerFilterEventByNo(Integer.valueOf(eventNo))) continue;
                dataJson = new JSONObject();
                dataJson.put("id", (Object)event.getEventNo());
                dataJson.put("text", (Object)I18nUtil.i18nCode((String)event.getName(), (Object[])new Object[0]));
                if (checkEventMap.containsKey(eventNo)) {
                    dataJson.put("checked", (Object)1);
                }
                if (this.accDeviceEventService.isDeviceEventByNo(Integer.valueOf(eventNo))) {
                    deviceEvent.add((Object)dataJson);
                    continue;
                }
                if (this.accDeviceEventService.isAuxinEventByNo(Integer.valueOf(eventNo))) {
                    auxInEvent.add((Object)dataJson);
                    continue;
                }
                doorEvent.add((Object)dataJson);
            }
            ArrayList<String> parentElement = new ArrayList<String>();
            parentElement.add(I18nUtil.i18nCode((String)"common_linkIO_doorEvent", (Object[])new Object[0]));
            if (auxInEvent.size() > 0) {
                parentElement.add(I18nUtil.i18nCode((String)"common_linkIO_auxInEvent", (Object[])new Object[0]));
            }
            if (deviceEvent.size() > 0) {
                parentElement.add(I18nUtil.i18nCode((String)"common_linkIO_deviceEvent", (Object[])new Object[0]));
            }
            int i = 0;
            while (i < parentElement.size()) {
                dataJson = new JSONObject();
                dataJson.put("id", (Object)(String.valueOf(i) + "_parent"));
                dataJson.put("text", parentElement.get(i));
                dataJson.put("open", (Object)"1");
                if (checkParentElementMap.containsKey(i)) {
                    dataJson.put("checked", (Object)"-1");
                }
                dataJson.put("item", (Object)(i == 0 ? doorEvent : (i == 1 ? auxInEvent : deviceEvent)));
                triggerOptArray.add((Object)dataJson);
                ++i;
            }
        }
        catch (Exception e) {
            throw new ZKBusinessException((Throwable)e);
        }
        zkResultMsg.setData((Object)triggerOptArray);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg getInOutInfo() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String devId = this.request.getParameter("devId");
        String accLinkageId = this.request.getParameter("accLinkageId");
        String[] triggerOpt = this.request.getParameter("triggerOpt").split(",");
        Map map = this.accLinkageService.getInOutInfo(devId, triggerOpt, accLinkageId);
        Map checkedOutputMap = (Map)map.get("checkedOutputMap");
        JSONArray doorOutputArray = (JSONArray)map.get("doorOutputArray");
        JSONArray auxOutOutputArray = (JSONArray)map.get("auxOutOutputArray");
        String devSn = (String)map.get("devSn");
        JSONArray inputArray = (JSONArray)map.get("inputArray");
        JSONObject actionObj = new JSONObject();
        actionObj.put("inputArray", (Object)inputArray);
        JSONArray outputArray = new JSONArray();
        if (this.accDeviceOptionService.isSupportFun(devSn, "~CtlAllRelayFunOn")) {
            outputArray = this.buildOutputArray(checkedOutputMap, doorOutputArray, auxOutOutputArray);
            actionObj.put("doorOutputArray", outputArray.get(0));
            actionObj.put("auxOutOutputArray", outputArray.get(1));
            actionObj.put("ctlAllRelayFunOn", (Object)true);
        } else {
            if (doorOutputArray.size() > 0) {
                actionObj.put("doorOutputArray", (Object)doorOutputArray);
            }
            if (auxOutOutputArray.size() > 0) {
                actionObj.put("auxOutOutputArray", (Object)auxOutOutputArray);
            }
            actionObj.put("ctlAllRelayFunOn", (Object)false);
        }
        zkResultMsg.setData((Object)actionObj);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public DxGrid selectDevicelist(AccLinkageSelectDeviceItem codition) {
        String filterDevId = this.accLinkageService.getAllFilterId();
        if (StringUtils.isBlank((CharSequence)codition.getSelectId())) {
            codition.setSelectId("-1");
        }
        if (codition.getType().equals("noSelected")) {
            if (StringUtils.isNotBlank((CharSequence)filterDevId)) {
                filterDevId = String.valueOf(codition.getSelectId()) + "," + filterDevId;
                codition.setSelectId(filterDevId);
            }
            codition.setSelectDeviceIdsNotIn(codition.getSelectId());
        } else if (codition.getType().equals("selected")) {
            codition.setSelectDeviceIdsIn(codition.getSelectId());
        }
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.accDeviceService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    private JSONArray buildOutputArray(Map<String, Map<Integer, String>> checkedOutputMap, JSONArray doorOutputArray, JSONArray auxOutArray) {
        JSONArray outputArray = new JSONArray();
        try {
            JSONObject dataJson = new JSONObject();
            if (doorOutputArray.size() > 0) {
                dataJson.put("id", (Object)"0_AccDoor");
                dataJson.put("text", (Object)I18nUtil.i18nCode((String)"common_linkIO_allDoor", (Object[])new Object[0]));
                dataJson.put("open", (Object)"1");
                if (checkedOutputMap != null && checkedOutputMap.containsKey("AccDoor") && checkedOutputMap.get("AccDoor").containsKey("0")) {
                    dataJson.put("checked", (Object)"1");
                }
                dataJson.put("item", (Object)doorOutputArray);
                outputArray.add((Object)dataJson);
            } else {
                outputArray.add((Object)"");
            }
            dataJson = new JSONObject();
            if (auxOutArray.size() > 0) {
                dataJson.put("id", (Object)"0_AccAuxOut");
                dataJson.put("text", (Object)I18nUtil.i18nCode((String)"common_linkIO_allAuxOut", (Object[])new Object[0]));
                dataJson.put("open", (Object)"1");
                if (checkedOutputMap != null && checkedOutputMap.containsKey("AccAuxOut") && checkedOutputMap.get("AccAuxOut").containsKey("0")) {
                    dataJson.put("checked", (Object)"1");
                }
                dataJson.put("item", (Object)auxOutArray);
                outputArray.add((Object)dataJson);
            } else {
                outputArray.add((Object)"");
            }
        }
        catch (Exception e) {
            log.error("buildOutputArray", (Throwable)e);
        }
        return outputArray;
    }

    public ZKResultMsg checkSMSModemParam() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.accLinkageService.completeSMSModemInfo());
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg getDigifortGlobalEvents(String linkageId, String type) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.accLinkageService.getDigifortGlobalEvents(linkageId, type));
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public DxGrid selectLineContactList(AccLinkageSelectContactItem condition) {
        Pager pager = new Pager();
        String selectIds = this.request.getParameter("selectValue");
        if (StringUtils.isBlank((CharSequence)selectIds)) {
            selectIds = "";
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getSelectId())) {
            selectIds = String.valueOf(selectIds) + "," + condition.getSelectId();
        }
        condition.setSelectId(selectIds);
        if (condition.getType().equals("noSelected")) {
            pager = this.accLinkageService.getNoExistLineContacts(condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getSelectIasPartition(AccLinkageSelectIasPartitionItem condition) {
        Pager pager = this.accLinkageService.getSelectIasPartition(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public TreeItem getIasPartitionTreeByIds(String iasPartitionIds) {
        return this.accLinkageService.getIasPartitionTreeByIds(this.request.getSession().getId(), iasPartitionIds);
    }

    public ZKResultMsg getArmTypeByManufacture(String manufacture) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = null;
        ZKResultMsg retData = this.accLinkageService.getArmTypeByManufacture(manufacture);
        JSONArray dataArray = (JSONArray)retData.getData();
        if (dataArray.size() > 0) {
            for (Object obj : dataArray) {
                JSONObject data = (JSONObject)obj;
                selectItem = new SelectItem();
                selectItem.setValue("" + data.get((Object)"type"));
                selectItem.setText((Object)("" + data.get((Object)"name")));
                selectItems.add(selectItem);
            }
        }
        return new ZKResultMsg(selectItems);
    }
}

