/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccLevelRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonService;
import com.zkteco.zkbiosecurity.acc.service.AccTimeSegService;
import com.zkteco.zkbiosecurity.acc.vo.AccLevelDoorExportItem;
import com.zkteco.zkbiosecurity.acc.vo.AccLevelDoorItem;
import com.zkteco.zkbiosecurity.acc.vo.AccLevelItem;
import com.zkteco.zkbiosecurity.acc.vo.AccLevelSelectDoorItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccLevelController
extends ExportController
implements AccLevelRemote {
    @Autowired
    private AccLevelService accLevelService;
    @Autowired
    private AccDoorService accDoorService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private AccTimeSegService accTimeSegService;
    @Autowired
    private AccPersonService accPersonService;
    private int AUTHDEV_MAX_PERSON = 5000;

    @RequiresPermissions(value={"acc:level"})
    public ModelAndView index() {
        return new ModelAndView("acc/level/accLevel");
    }

    @RequiresPermissions(value={"acc:level:add", "acc:level:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("personCount", (Object)this.accLevelService.getLevelPersonCount(id));
            this.request.setAttribute("doorCount", (Object)this.accLevelService.getLevelDoorCount(id));
            this.request.setAttribute("item", (Object)this.accLevelService.getItemById(id));
        } else {
            this.request.setAttribute("timeSegId", (Object)(Objects.nonNull(this.accTimeSegService.getInitTimeSeg()) ? this.accTimeSegService.getInitTimeSeg().getId() : ""));
        }
        return new ModelAndView("acc/level/editAccLevel");
    }

    @RequiresPermissions(value={"acc:level:add", "acc:level:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="common_op_edit", requestParams={"name"}, opContent="common_level_name")
    public ZKResultMsg save(AccLevelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        item = this.accLevelService.saveItem(item);
        String levelId = item.getId();
        if (StringUtils.isNotBlank((CharSequence)levelId)) {
            this.accLevelService.syncTimeSegVisLevelToDev(levelId);
            if (item.getChangeLevel() != null && item.getChangeLevel().booleanValue()) {
                List deviceIdList = this.accLevelService.getDevIdsByLevelId(levelId);
                List personIdList = this.accLevelService.getPersonIdsByLevelId(levelId);
                ArrayList<String> tempPersonIdList = new ArrayList<String>();
                int i = 0;
                int devSize = deviceIdList.size();
                while (i < devSize) {
                    int total = (int)((double)i * 100.0 / (double)devSize);
                    total = total == 100 ? 99 : total;
                    int j = 0;
                    int personSize = personIdList.size();
                    while (j < personSize) {
                        tempPersonIdList.add((String)personIdList.get(j));
                        if (tempPersonIdList.size() % 500 == 0) {
                            this.accLevelService.syncTimeSegLevelToDev((String)deviceIdList.get(i), tempPersonIdList);
                            this.progressCache.setProcess(new ProcessBean((int)((double)j * 100.0 / (double)personSize), total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                            tempPersonIdList = new ArrayList();
                        }
                        ++j;
                    }
                    if (tempPersonIdList.size() > 0) {
                        this.accLevelService.syncTimeSegLevelToDev((String)deviceIdList.get(i), tempPersonIdList);
                        this.progressCache.setProcess(new ProcessBean(100, total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                        tempPersonIdList = new ArrayList();
                    }
                    this.accLevelService.issuedDownloadToDev("devType", (String)deviceIdList.get(i));
                    ++i;
                }
            }
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]), "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        res.setData((Object)item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:level:refresh"})
    public DxGrid list(AccLevelItem codition) {
        Pager pager = this.accLevelService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:level:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="common_op_del", requestParams={"names"}, opContent="common_level_name")
    public ZKResultMsg del(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            ArrayList<String> levelIdList = new ArrayList<String>(Arrays.asList(ids.split(",")));
            AccLevelItem accLevelItem = new AccLevelItem();
            accLevelItem.setInitFlag(Boolean.valueOf(true));
            if (levelIdList.contains(((AccLevelItem)this.accLevelService.getByCondition(accLevelItem).get(0)).getId())) {
                resultMsg.setRet("500");
                resultMsg.setMsg("common_prompt_initDataCanNotDel");
            } else {
                this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
                ArrayList<String> tempPersonIdList = new ArrayList<String>();
                int i = 0;
                int levelSize = levelIdList.size();
                while (i < levelSize) {
                    int total = (int)((double)i * 100.0 / (double)levelSize);
                    total = total == 100 ? 99 : total;
                    List personIdList = this.accLevelService.getPersonIdsByLevelId((String)levelIdList.get(i));
                    if (personIdList != null && personIdList.size() > 0) {
                        List deviceIdList = this.accLevelService.getDevIdsByLevelId((String)levelIdList.get(i));
                        for (String deviceId : deviceIdList) {
                            int j = 0;
                            int personSize = personIdList.size();
                            while (j < personSize) {
                                tempPersonIdList.add((String)personIdList.get(j));
                                if (tempPersonIdList.size() % 500 == 0) {
                                    this.accLevelService.immeDelLevel(deviceId, (String)levelIdList.get(i), tempPersonIdList);
                                    this.progressCache.setProcess(new ProcessBean((int)((double)j * 100.0 / (double)personSize), total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                                    tempPersonIdList = new ArrayList();
                                }
                                ++j;
                            }
                            if (tempPersonIdList.size() <= 0) continue;
                            this.accLevelService.immeDelLevel(deviceId, (String)levelIdList.get(i), tempPersonIdList);
                            this.progressCache.setProcess(new ProcessBean(100, total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                        }
                    } else {
                        this.accLevelService.delAccLevelDoorByLevelId((String)levelIdList.get(i));
                    }
                    ++i;
                }
                this.accLevelService.deleteByIds(ids);
                this.progressCache.finishProcess(String.valueOf(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0])) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg getLevelList() {
        return new ZKResultMsg((Object)this.accLevelService.getLevelList(this.request.getSession().getId()));
    }

    public DxGrid selectDoorlist(AccLevelSelectDoorItem codition) {
        List doorIdList = this.accDoorService.getDoorIdAsReader();
        String levelId = codition.getLevelId();
        if (StringUtils.isBlank((CharSequence)codition.getSelectId())) {
            codition.setSelectId("-1");
        }
        if (codition.getType().equals("noSelected")) {
            if (doorIdList != null && doorIdList.size() > 0) {
                codition.setSelectId(String.valueOf(codition.getSelectId()) + "," + StringUtils.join((Iterable)doorIdList, (String)","));
            }
            codition.setSelectDoorIdsNotIn(codition.getSelectId());
        } else if (codition.getType().equals("selected")) {
            codition.setSelectDoorIdsIn(codition.getSelectId());
        }
        codition.setFilterId(levelId);
        codition.setEnabled(Boolean.valueOf(true));
        Pager pager = this.accDoorService.getPagerFilterAuth(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:level:addDoor"})
    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_map_addDoor", requestParams={"levelName", "doorNames"}, opContent="common_level_name")
    public ZKResultMsg addDoor(String levelId, String doorIds) {
        if (StringUtils.isNotBlank((CharSequence)levelId) && StringUtils.isNotBlank((CharSequence)doorIds)) {
            ArrayList<String> doorIdList = new ArrayList<String>(Arrays.asList(doorIds.split(",")));
            List asWGReaderDoorIdList = this.accDoorService.getDoorIdsAsWGReaderByDoorId(doorIdList);
            if (asWGReaderDoorIdList != null && asWGReaderDoorIdList.size() > 0) {
                doorIdList.addAll(asWGReaderDoorIdList);
            }
            String clientId = this.request.getParameter("clientId");
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            this.accLevelService.addLevelByParamIds(StringUtils.join(doorIdList, (String)","), levelId, "door");
            List deviceIdList = this.accDoorService.getDevAndParentDevIdsByDoorIds(doorIdList);
            List personIdList = this.accLevelService.getPersonIdsByLevelId(levelId);
            if (personIdList != null && personIdList.size() > 0) {
                List personArrayIds = this.accPersonService.splitPersonIds(StringUtils.join((Iterable)personIdList, (String)","), 500);
                int[] currentCount = new int[1];
                int[] totalCount = new int[]{personArrayIds.size()};
                personArrayIds.parallelStream().forEach(personArrayId -> {
                    this.accLevelService.handleLevelAddDoor(personArrayId, StringUtils.join((Iterable)deviceIdList, (String)","), levelId);
                    nArray[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
                this.accLevelService.issuedDownloadToDev("devType", StringUtils.join((Iterable)deviceIdList, (String)","));
            }
            this.accLevelService.setVisitorToDev(levelId, deviceIdList);
            this.progressCache.finishProcess(String.valueOf(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0])) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:level:delDoor"})
    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_level_doorDelete", requestParams={"levelName", "doorNames"}, opContent="common_level_name")
    public ZKResultMsg delDoor(String levelId, String doorIds) {
        if (StringUtils.isNotBlank((CharSequence)levelId) && StringUtils.isNotBlank((CharSequence)doorIds)) {
            ArrayList<String> doorIdList = new ArrayList<String>(Arrays.asList(doorIds.split(",")));
            List asWGReaderDoorIdList = this.accDoorService.getDoorIdsAsWGReaderByDoorIdAndLevelId(doorIdList, levelId);
            if (asWGReaderDoorIdList != null && asWGReaderDoorIdList.size() > 0) {
                doorIdList.addAll(asWGReaderDoorIdList);
            }
            String clientId = this.request.getParameter("clientId");
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            this.accLevelService.delLevelDoorByParams(levelId, doorIdList);
            List deviceIdList = this.accDoorService.getDevIdsByDoorIds(doorIdList);
            List personIdList = this.accLevelService.getPersonIdsByLevelId(levelId);
            if (personIdList != null && personIdList.size() > 0) {
                List personArrayIds = this.accPersonService.splitPersonIds(StringUtils.join((Iterable)personIdList, (String)","), 500);
                int[] currentCount = new int[1];
                int[] totalCount = new int[]{personArrayIds.size()};
                personArrayIds.parallelStream().forEach(personArrayId -> {
                    this.accLevelService.handleLevelDelDoor(levelId, personArrayId, StringUtils.join((Iterable)deviceIdList, (String)","));
                    this.accLevelService.deleteAccLevel4OtherModule(doorIdList, Arrays.asList(personArrayId.split(",")));
                    nArray[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
            }
            this.accLevelService.delVisitorToDev(levelId, deviceIdList);
            this.progressCache.finishProcess(String.valueOf(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0])) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:level:refresh"})
    public DxGrid doorList(AccLevelDoorItem codition) {
        List doorIdList = this.accDoorService.getDoorIdAsReader();
        if (doorIdList != null && doorIdList.size() > 0) {
            codition.setNotInId(StringUtils.join((Iterable)doorIdList, (String)","));
        }
        Pager pager = this.accDoorService.accLevelDoorList(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg doorListByApp(String id) {
        AccLevelDoorItem condition = new AccLevelDoorItem();
        List doorIdList = this.accDoorService.getDoorIdAsReader();
        if (doorIdList != null && doorIdList.size() > 0) {
            condition.setNotInId(StringUtils.join((Iterable)doorIdList, (String)","));
        }
        List acclevels = this.accLevelService.getLevelByPersonId(id);
        ArrayList doors = new ArrayList();
        for (AccLevelItem item : acclevels) {
            String levelId = item.getId();
            condition.setAccLevelId(levelId);
            List doorItems = this.accDoorService.getItemsByPage((BaseItem)condition, 0, 1000000).getData();
            doors.addAll(doorItems);
        }
        ZKResultMsg msg = new ZKResultMsg(doors);
        return msg;
    }

    public String valid(String name) {
        AccLevelItem item = this.accLevelService.getItemByName(name);
        boolean rs = item == null;
        return String.valueOf(rs);
    }

    @RequiresPermissions(value={"acc:level:export"})
    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_level_exportLevel", opContent="acc_level_exportLevel")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AccLevelItem accLevelItem = new AccLevelItem();
        this.setConditionValue((BaseItem)accLevelItem);
        String userId = this.accLevelService.getUserIdBySessionId(request.getSession().getId());
        accLevelItem.setUserId(userId);
        List accLevelItemList = this.accLevelService.getExportLevelItemList(accLevelItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(accLevelItemList, AccLevelItem.class);
    }

    public ZKResultMsg getPersonCount(String levelId) {
        Long personCount = this.accLevelService.getLevelPersonCount(levelId);
        return new ZKResultMsg((Object)personCount);
    }

    public ZKResultMsg levelIsDelete(String ids) {
        ZKResultMsg zkResultMsg = this.accLevelService.levelIsDelete(ids);
        if ("vis".equals(zkResultMsg.getData())) {
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"acc_level_visUsed", (Object[])new Object[]{zkResultMsg.getMsg()}));
        }
        return zkResultMsg;
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_eventNo_8", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:openDoor"})
    public ZKResultMsg openDoor(String ids, String openInterval) {
        this.checkUserPwd();
        Map dataMap = this.accLevelService.operateDoor("openDoor", openInterval, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_eventNo_9", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:closeDoor"})
    public ZKResultMsg closeDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accLevelService.operateDoor("closeDoor", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_eventNo_7", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:cancelAlarmDoor"})
    public ZKResultMsg cancelAlarmDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accLevelService.operateDoor("cancelAlarm", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_eventNo_8", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:normalOpenDoor"})
    public ZKResultMsg normalOpenDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accLevelService.operateDoor("normalOpenDoor", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="common_enable", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:enableDoor"})
    public ZKResultMsg enableDoor(String ids) {
        ZKResultMsg res = this.accLevelService.enableDoor(ids, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="common_disable", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:disableDoor"})
    public ZKResultMsg disableDoor(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        this.accLevelService.disableDoor(ids, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_newEventNo_233", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:lockDoor"})
    public ZKResultMsg lockDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accLevelService.operateDoor("lockDoor", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_newEventNo_234", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:unLockDoor"})
    public ZKResultMsg unLockDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accLevelService.operateDoor("unLockDoor", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_eventNo_11", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:enableNormalOpenDoor"})
    public ZKResultMsg enableNormalOpenDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accLevelService.operateDoor("enableNormalOpenDoor", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_eventNo_10", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:disableNormalOpenDoor"})
    public ZKResultMsg disableNormalOpenDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accLevelService.operateDoor("disableNormalOpenDoor", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    public ZKResultMsg authDevAddLevelVerify(String id) {
        Long personCount = this.accLevelService.getLevelPersonCount(id);
        if (personCount > (long)this.AUTHDEV_MAX_PERSON) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"acc_level_personExceedMax", (Object[])new Object[]{personCount, this.AUTHDEV_MAX_PERSON}), (Object[])new Object[0]);
        }
        return ZKResultMsg.successMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_level_exportLevelDoor", opContent="acc_level_exportLevelDoor")
    @RequiresPermissions(value={"acc:levelDoor:export"})
    public void exportLevelDoor(HttpServletRequest request, HttpServletResponse response) {
        this.checkUserPwd();
        String levelIds = request.getParameter("levelIds");
        AccLevelDoorExportItem accLevelDoorItem = new AccLevelDoorExportItem();
        accLevelDoorItem.setLevelIdsIn(levelIds);
        List accLevelDoorItemList = this.accDoorService.getExportLevelDoorItemList(accLevelDoorItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(accLevelDoorItemList, AccLevelDoorExportItem.class);
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_level_importLevel", opContent="acc_level_importLevel")
    @RequiresPermissions(value={"acc:level:import"})
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0])) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0])) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), AccLevelItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0])) + "<br/>"));
            boolean updateExistData = false;
            String isupdateExistData = this.request.getParameter("updateExistData");
            if ("1".equals(isupdateExistData)) {
                updateExistData = true;
            }
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.accLevelService.importLevelData(itemList, updateExistData));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import AccLevel Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_level_importLevelDoor", opContent="acc_level_importLevelDoor")
    @RequiresPermissions(value={"acc:levelDoor:import"})
    public ZKResultMsg importLevelDoorExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0])) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0])) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), AccLevelDoorExportItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0])) + "<br/>"));
            boolean updateExistData = false;
            String isupdateExistData = this.request.getParameter("updateExistData");
            if ("1".equals(isupdateExistData)) {
                updateExistData = true;
            }
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.accLevelService.importLevelDoorData(itemList, updateExistData));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import AccLevelDoor Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    public void checkUserPwd() {
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                boolean ret = this.accLevelService.verifyLoginPwd(this.request.getSession().getId(), loginPwd);
                if (!ret) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
    }
}

