/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccFirstInLastOutRemote;
import com.zkteco.zkbiosecurity.acc.service.AccFirstInLastOutService;
import com.zkteco.zkbiosecurity.acc.service.AccTransactionService;
import com.zkteco.zkbiosecurity.acc.vo.AccFirstInLastOutItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccFirstInLastOutController
extends ExportController
implements AccFirstInLastOutRemote {
    @Autowired
    private AccFirstInLastOutService accFirstInLastOutService;
    @Autowired
    private AccTransactionService accTransactionService;

    @RequiresPermissions(value={"acc:firstInLastOut"})
    public ModelAndView index() {
        return new ModelAndView("acc/firstInLastOut/accFirstInLastOut");
    }

    @RequiresPermissions(value={"acc:firstInLastOut:refresh"})
    public DxGrid list(AccFirstInLastOutItem condition) {
        Pager pager = this.accFirstInLastOutService.loadTransactionByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"acc:firstInLastOut:clearData"})
    @LogRequest(module="acc_module", object="acc_leftMenu_firstInLastOut", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.accFirstInLastOutService.deleteAllData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:firstInLastOut:export"})
    @LogRequest(module="acc_module", object="acc_leftMenu_firstInLastOut", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AccFirstInLastOutItem accFirstInLastOutItem = new AccFirstInLastOutItem();
        this.setConditionValue((BaseItem)accFirstInLastOutItem);
        List itemList = this.accFirstInLastOutService.getExportItemData(request.getSession().getId(), accFirstInLastOutItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AccFirstInLastOutItem.class);
    }
}

