/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccDoorRemote;
import com.zkteco.zkbiosecurity.acc.service.AccBaseDictionaryService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceOptionService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceVerifyModeService;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccRTMonitorService;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceOptionItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDoorItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccDoorController
extends ExportController
implements AccDoorRemote {
    @Autowired
    private AccDoorService accDoorService;
    @Autowired
    private AccDeviceOptionService accDeviceOptionService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccRTMonitorService accRTMonitorService;
    @Autowired
    private AccBaseDictionaryService accBaseDictionaryService;
    @Autowired
    private AccDeviceVerifyModeService accDeviceVerifyModeService;
    @Autowired
    private AccLevelService accLevelService;

    @RequiresPermissions(value={"acc:door"})
    public ModelAndView index() {
        return new ModelAndView("acc/door/accDoor");
    }

    @RequiresPermissions(value={"acc:door:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String newVFModeNos;
            AccDoorItem item = this.accDoorService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
            boolean delayOpenDoorFunOn = this.accDeviceOptionService.isSupportFun(item.getDeviceSn(), "DelayOpenDoorFunOn");
            this.request.setAttribute("delayOpenDoorFunOn", (Object)delayOpenDoorFunOn);
            boolean userOpenDoorDelayFunOn = this.accDeviceOptionService.isSupportFun(item.getDeviceSn(), "UserOpenDoorDelayFunOn");
            this.request.setAttribute("userOpenDoorDelayFunOn", (Object)userOpenDoorDelayFunOn);
            boolean multiCardInterTimeFunOn = this.accDeviceOptionService.isSupportFun(item.getDeviceSn(), "MultiCardInterTimeFunOn");
            this.request.setAttribute("multiCardInterTimeFunOn", (Object)multiCardInterTimeFunOn);
            boolean longLockDelay = !this.accDoorService.isNewAccessControlDevice(item.getDeviceId());
            this.request.setAttribute("longLockDelay", (Object)longLockDelay);
            boolean inputIOSettingFunOn = this.accDeviceOptionService.isSupportFunList(item.getDeviceSn(), 8);
            this.request.setAttribute("inputIOSettingFunOn", (Object)inputIOSettingFunOn);
            boolean supportWGDataProcess = this.accDeviceOptionService.isSupportFunList(item.getDeviceSn(), 33);
            this.request.setAttribute("supportWGDataProcess", (Object)supportWGDataProcess);
            boolean allowSUAccessLock = this.accDeviceOptionService.isSupportFunList(item.getDeviceSn(), 48);
            this.request.setAttribute("allowSUAccessLock", (Object)allowSUAccessLock);
            this.request.setAttribute("editPage", (Object)true);
            AccDeviceOptionItem newVFStylesItem = this.accDeviceOptionService.getDevOptValueBySnAndName(item.getDeviceSn(), "NewVFStyles");
            if (Objects.nonNull(newVFStylesItem) && StringUtils.isNotBlank((CharSequence)newVFStylesItem.getValue()) && !"0".equals(newVFStylesItem.getValue()) && StringUtils.isNotBlank((CharSequence)(newVFModeNos = this.accDeviceVerifyModeService.getVerifyModeNosByNewVFStyles("" + item.getVerifyMode())))) {
                String verifyStyleLogic = String.valueOf(0).equals(newVFModeNos.split(",")[0]) ? "1" : "0";
                this.request.setAttribute("verifyStyleLogic", (Object)verifyStyleLogic);
                this.request.setAttribute("newVFStyles", (Object)newVFModeNos);
            }
            if (Short.valueOf(item.getDevMachineType()) == 101) {
                return new ModelAndView("acc/door/editAccDoorACD");
            }
        }
        return new ModelAndView("acc/door/editAccDoor");
    }

    @RequiresPermissions(value={"acc:door:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_door", opType="common_op_edit", requestParams={"name"}, opContent="acc_door_name")
    public ZKResultMsg save(AccDoorItem item, @RequestParam(required=false) String applyTo) {
        ZKResultMsg res = new ZKResultMsg();
        this.accDoorService.saveItem(item, applyTo);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:door:refresh"})
    public DxGrid list(AccDoorItem codition) {
        Pager pager = this.accDoorService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:door:openDoor", "acc:door:closeDoor", "acc:door:cancelAlarm", "acc:door:normalOpenDoor", "acc:door:lockDoor", "acc:door:unLockDoor", "acc:door:enableNormalOpenDoor", "acc:door:disableNormalOpenDoor"})
    public ModelAndView getDoorIds(String ids) {
        String[] idArr = ids.split(",");
        String type = this.request.getParameter("type");
        Map retMap = this.accDoorService.getDoorIds(idArr, type);
        this.request.setAttribute("retIds", retMap.get("retIds"));
        this.request.setAttribute("doorsName", retMap.get("doorsName"));
        this.request.setAttribute("disabledDoorsName", retMap.get("disabledDoorsName"));
        this.request.setAttribute("offlineDoorsName", retMap.get("offlineDoorsName"));
        this.request.setAttribute("notSupportDoorsName", retMap.get("notSupportDoorsName"));
        this.request.setAttribute("type", (Object)type);
        return new ModelAndView("acc/door/opAccDoor");
    }

    public ZKResultMsg getVerifyMode(String deviceId) {
        List selectItemList = this.accDoorService.getVerifyMode(deviceId);
        return new ZKResultMsg((Object)selectItemList);
    }

    public ZKResultMsg getWiegandFmtList() {
        List selectItemList = this.accDoorService.getWiegandFmtList();
        return new ZKResultMsg((Object)selectItemList);
    }

    public boolean validGlobalApb(String doorId) {
        return this.accDoorService.validGlobalApb(doorId);
    }

    public boolean isExist(String name) {
        return this.accDoorService.isExist(name);
    }

    public boolean checkPwd(String forcePwd) {
        return this.accDoorService.checkPwd(forcePwd);
    }

    public ZKResultMsg getAccDeviceOpt(String deviceId) {
        ZKResultMsg res = new ZKResultMsg();
        Map devOptMap = this.accDoorService.getAccDeviceOpt(deviceId);
        res.setData((Object)devOptMap);
        return res;
    }

    @RequiresPermissions(value={"acc:door:enable"})
    @LogRequest(module="acc_module", object="acc_leftMenu_door", opType="common_enable", requestParams={"name"}, opContent="acc_door_name")
    public ZKResultMsg enable(String ids) {
        ZKResultMsg res = this.accDoorService.enable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:door:disable"})
    @LogRequest(module="acc_module", object="acc_leftMenu_door", opType="common_disable", requestParams={"name"}, opContent="acc_door_name")
    public ZKResultMsg disable(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        this.accDoorService.disable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_door", opType="acc_eventNo_8", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:door:openDoor"})
    public ZKResultMsg openDoor(String ids, String openInterval) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("openDoor", openInterval, ids);
        return this.dealResultData(dataMap);
    }

    @RequiresPermissions(value={"acc:door:closeDoor"})
    @LogRequest(module="acc_module", object="acc_leftMenu_door", opType="acc_eventNo_9", requestParams={"name"}, opContent="acc_door_name")
    public ZKResultMsg closeDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("closeDoor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_door", opType="acc_eventNo_7", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:door:cancelAlarm"})
    public ZKResultMsg cancelAlarm(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("cancelAlarm", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_door", opType="acc_newEventNo_233", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:door:lockDoor"})
    public ZKResultMsg lockDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("lockDoor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_door", opType="acc_newEventNo_234", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:door:unLockDoor"})
    public ZKResultMsg unLockDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("unLockDoor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_door", opType="acc_rtMonitor_remoteNormalOpen", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:door:normalOpenDoor"})
    public ZKResultMsg normalOpenDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("normalOpenDoor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_door", opType="acc_eventNo_11", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:door:enableNormalOpenDoor"})
    public ZKResultMsg enableNormalOpenDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("enableNormalOpenDoor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_door", opType="acc_eventNo_10", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:door:disableNormalOpenDoor"})
    public ZKResultMsg disableNormalOpenDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("disableNormalOpenDoor", null, ids);
        return this.dealResultData(dataMap);
    }

    private ZKResultMsg dealResultData(Map<String, String> dataMap) {
        String doorName;
        int n;
        int n2;
        String[] stringArray;
        String cmdIdData = dataMap.get("cmdId");
        String msg = "";
        ZKResultMsg resultMsg = new ZKResultMsg();
        if ("true".equals(dataMap.get("notExistDev"))) {
            msg = String.valueOf(I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0])) + I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]);
            resultMsg.setMsg(msg);
            return resultMsg;
        }
        if (!"".equals(cmdIdData)) {
            stringArray = cmdIdData.split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String cmdData = stringArray[n];
                String cmdId = cmdData.split("=")[0];
                String doorName2 = cmdData.split("=")[1];
                Map resultMap = this.accDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (Objects.isNull(resultMap)) {
                    msg = String.valueOf(msg) + doorName2 + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + ";";
                } else {
                    Integer ret = Integer.valueOf((String)resultMap.get("result"));
                    if (Objects.isNull(ret)) {
                        msg = String.valueOf(msg) + doorName2 + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + ";";
                    } else if (ret < 0) {
                        String failedInfo = I18nUtil.i18nCode((String)this.accBaseDictionaryService.getCommReason(ret.intValue()), (Object[])new Object[0]);
                        msg = String.valueOf(msg) + doorName2 + "," + I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0]) + failedInfo + ";";
                    }
                }
                ++n;
            }
        }
        if (!"".equals(dataMap.get("offline"))) {
            stringArray = dataMap.get("offline").split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                doorName = stringArray[n];
                msg = String.valueOf(msg) + doorName + "," + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + ";";
                ++n;
            }
        }
        if (!"".equals(dataMap.get("notSupport"))) {
            stringArray = dataMap.get("notSupport").split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                doorName = stringArray[n];
                msg = String.valueOf(msg) + doorName + "," + I18nUtil.i18nCode((String)"acc_dev_devNotSupportFunction", (Object[])new Object[0]) + ";";
                ++n;
            }
        }
        if (!"".equals(msg)) {
            resultMsg.setRet("400");
            resultMsg.setMsg(msg);
        }
        resultMsg.setData((Object)"");
        return resultMsg;
    }

    public void checkUserPwd() {
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                boolean ret = this.accLevelService.verifyLoginPwd(this.request.getSession().getId(), loginPwd);
                if (!ret) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
    }
}

