/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.constants.AccConstants;
import com.zkteco.zkbiosecurity.acc.remote.AccDeviceVerifyModeRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceVerifyModeService;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceVerifyModeItem;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class AccDeviceVerifyModeController
extends BaseController
implements AccDeviceVerifyModeRemote {
    @Autowired
    private AccDeviceVerifyModeService accDeviceVerifyModeService;

    public TreeItem getDeviceVerifyModeTree() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        Map verifyModesMap = AccConstants.VERIFY_MODE;
        Set keySet = verifyModesMap.keySet();
        Object[] keySetArray = keySet.toArray();
        Arrays.sort(keySetArray);
        Object[] objectArray = keySetArray;
        int n = keySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            TreeItem item = new TreeItem();
            item.setId((String)verifyModesMap.get(key));
            item.setText(I18nUtil.i18nCode((String)((String)verifyModesMap.get(key)), (Object[])new Object[0]));
            item.setParent(new TreeItem("0"));
            items.add(item);
            ++n2;
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public TreeItem getDeviceVerifyModeTreeByDeviceId(String deviceId) {
        List accDeviceVerifyModeItemList = this.accDeviceVerifyModeService.getVerifyModeByDeviceId(deviceId);
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (AccDeviceVerifyModeItem verifyModeItem : accDeviceVerifyModeItemList) {
            TreeItem item = new TreeItem();
            item.setId(verifyModeItem.getVerifyNo().toString());
            item.setText(I18nUtil.i18nCode((String)verifyModeItem.getName(), (Object[])new Object[0]));
            item.setParent(new TreeItem(verifyModeItem.getDeviceSn()));
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public TreeItem getSupportNewVerifyModeTree() {
        List accDeviceVerifyModeItemList = this.accDeviceVerifyModeService.getSupportNewVerifyModeTree();
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (AccDeviceVerifyModeItem verifyModeItem : accDeviceVerifyModeItemList) {
            TreeItem item = new TreeItem();
            item.setId(verifyModeItem.getVerifyNo().toString());
            item.setText(I18nUtil.i18nCode((String)verifyModeItem.getName(), (Object[])new Object[0]));
            item.setParent(new TreeItem("0"));
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }
}

