/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceMonitorService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;

@Controller
public class AccDeviceMonitorWSController
extends BaseController {
    @Autowired
    private AccDeviceMonitorService accDeviceMonitorService;
    @Autowired
    private AccDeviceService accDeviceService;

    @MessageMapping(value={"/accDeviceMonitor/getDeviceEvents"})
    @SendTo(value={"/topic/accDeviceMonitor/getDeviceEvents"})
    public JSONObject getDeviceEvents(String _params) {
        JSONObject params = JSONObject.parseObject((String)_params);
        JSONObject dxGrid = new JSONObject();
        String areaIds = params.containsKey((Object)"areaId") ? params.getString("areaId") : "";
        dxGrid.put("pos", (Object)0);
        ArrayList rows = new ArrayList();
        List accDeviceMonitorItems = this.accDeviceMonitorService.getDeviceMonitor(areaIds);
        accDeviceMonitorItems.forEach(item -> {
            JSONObject row = new JSONObject();
            row.put("id", (Object)item.getId());
            JSONObject userData = new JSONObject();
            userData.put("areaId", (Object)item.getAreaId());
            userData.put("status", (Object)item.getDevStatus());
            row.put("userdata", (Object)userData);
            if ("normal".equals(item.getDevStatus())) {
                row.put("style", (Object)"color:green");
                row.put("dataLevel", (Object)0);
            } else if ("disable".equals(item.getDevStatus())) {
                row.put("style", (Object)"color:#E57A14");
                row.put("dataLevel", (Object)1);
            } else {
                row.put("style", (Object)"color:red");
                row.put("dataLevel", (Object)2);
            }
            JSONArray data = new JSONArray();
            data.add((Object)item.getDevName());
            data.add((Object)item.getDevSn());
            data.add((Object)item.getAreaName());
            data.add((Object)item.getOpState());
            data.add((Object)item.getCurState());
            data.add((Object)item.getCmdCount());
            data.add((Object)(item.getLastError().equals("") ? I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]) : item.getLastError()));
            row.put("data", (Object)data);
            rows.add(row);
        });
        dxGrid.put("rows", rows);
        dxGrid.put("clientId", params.get((Object)"clientId"));
        dxGrid.put("total_count", (Object)rows.size());
        return dxGrid;
    }
}

