/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccDeviceMonitorRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceMonitorService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceMonitorItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccDeviceMonitorController
extends ExportController
implements AccDeviceMonitorRemote {
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccDeviceMonitorService accDeviceMonitorService;

    @RequiresPermissions(value={"acc:deviceMonitor", "acc:deviceMonitor:browse"})
    public ModelAndView index() {
        return new ModelAndView("acc/deviceMonitor/accDeviceMonitor");
    }

    @LogRequest(module="acc_module", object="common_leftMenu_devMonitioring", opType="acc_dev_clearAllCmdCache", requestParams={"alias"}, opContent="common_dev_name")
    @RequiresPermissions(value={"acc:deviceMonitor:clearCmdCache"})
    public ZKResultMsg clearCmdCache(String sn, String alias) {
        this.accDeviceService.clearCmdCache(sn, new String[]{"-1112"});
        ZKResultMsg resultMsg = new ZKResultMsg();
        resultMsg.setMsg("common_devMonitor_clearCmdSuccess");
        return resultMsg;
    }

    @LogRequest(module="acc_module", object="common_leftMenu_devMonitioring", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"acc:deviceMonitor:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        List accDeviceMonitorItemList;
        String exportType = request.getParameter("exportType");
        String recordStart = request.getParameter("recordstart");
        String recordCount = request.getParameter("recordcount");
        String queryConditions = request.getParameter("queryConditions");
        String[] conditionAry = queryConditions.replaceAll("%20", " ").split("&");
        String devStatus = "";
        String[] stringArray = conditionAry;
        int n = conditionAry.length;
        int n2 = 0;
        while (n2 < n) {
            String query = stringArray[n2];
            if (query.startsWith("devStatus")) {
                devStatus = query.split("=", 2)[1];
            }
            ++n2;
        }
        int beginIndex = 0;
        int endIndex = 30000;
        int exportCount = 30000;
        if (exportType.equals("3") && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            beginIndex = Integer.parseInt(recordStart) - 1;
            exportCount = Integer.parseInt(recordCount) > 30000 ? 30000 : Integer.parseInt(recordCount);
        }
        AccDeviceItem accDeviceItem = new AccDeviceItem();
        this.setConditionValue((BaseItem)accDeviceItem);
        String areaIds = this.accDeviceService.getAreaIdsByAuthFilter(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)areaIds)) {
            accDeviceItem.setAreaIdIn(areaIds);
        }
        if (!(accDeviceMonitorItemList = this.accDeviceMonitorService.filterDeviceState(accDeviceItem, beginIndex, exportCount, devStatus)).isEmpty()) {
            accDeviceMonitorItemList.stream().forEach(accDeviceMonitorItem -> {
                if (StringUtils.isBlank((CharSequence)accDeviceMonitorItem.getLastError())) {
                    accDeviceMonitorItem.setLastError(I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]));
                }
            });
        }
        this.excelExport(accDeviceMonitorItemList, AccDeviceMonitorItem.class);
    }
}

