/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccDeviceEventRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceEventService;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceEventItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceEventSelectItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccDeviceEventController
extends BaseController
implements AccDeviceEventRemote {
    @Autowired
    private AccDeviceEventService accDeviceEventService;

    @RequiresPermissions(value={"acc:deviceEvent"})
    public ModelAndView index() {
        return new ModelAndView("acc/deviceEvent/accDeviceEvent");
    }

    @RequiresPermissions(value={"acc:deviceEvent:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accDeviceEventService.getItemById(id));
        }
        return new ModelAndView("acc/deviceEvent/editAccDeviceEvent");
    }

    @RequiresPermissions(value={"acc:deviceEvent:edit"})
    @LogRequest(module="acc_module", object="common_leftMenu_event", opType="common_op_edit", requestParams={"name"}, opContent="common_event_name")
    public ZKResultMsg save(AccDeviceEventItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String fileOpType = this.request.getParameter("opType");
        String syncAllDevice = this.request.getParameter("syncAllDevice");
        this.accDeviceEventService.saveItem(item, fileOpType, syncAllDevice);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:deviceEvent:refresh"})
    public DxGrid list(AccDeviceEventItem codition) {
        Pager pager = this.accDeviceEventService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        List data = pager.getData();
        for (AccDeviceEventItem event : data) {
            event.setLevelAndEventPriority(event.getEventLevel() + ";" + event.getEventPriority());
        }
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:deviceEvent:del"})
    public ZKResultMsg del(String ids) {
        this.accDeviceEventService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:deviceEvent:setSound"})
    public ZKResultMsg setSound(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String fileOpType = this.request.getParameter("opType");
            String baseMediaFileId = this.request.getParameter("baseMediaFileId");
            String baseMediaFileName = this.request.getParameter("baseMediaFileName");
            String baseMediaFilePath = this.request.getParameter("baseMediaFilePath");
            String baseMediaFileSize = this.request.getParameter("baseMediaFileSize");
            String baseMediaFileSuffix = this.request.getParameter("baseMediaFileSuffix");
            this.accDeviceEventService.setSound(ids, fileOpType, baseMediaFileId, baseMediaFileName, baseMediaFilePath, baseMediaFileSize, baseMediaFileSuffix);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public TreeItem tree() {
        Set eventList = this.accDeviceEventService.getAllEventNameSet();
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (String eventName : eventList) {
            TreeItem item = new TreeItem();
            item.setId(eventName);
            item.setText(I18nUtil.i18nCode((String)eventName, (Object[])new Object[0]));
            item.setParent(new TreeItem("0"));
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public DxGrid listSelect(AccDeviceEventSelectItem condition) {
        Pager pager = new Pager();
        int pageNo = this.getPageNo();
        int pageSize = this.getPageSize();
        Set eventList = this.accDeviceEventService.getAllEventNameSet();
        ArrayList<AccDeviceEventSelectItem> items = new ArrayList<AccDeviceEventSelectItem>();
        AccDeviceEventSelectItem item = null;
        for (String eventName : eventList) {
            String name = I18nUtil.i18nCode((String)eventName, (Object[])new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)condition.getName()) && !name.contains(condition.getName())) continue;
            item = new AccDeviceEventSelectItem();
            item.setName(name);
            item.setId(eventName);
            items.add(item);
        }
        int beginIndex = pageNo * pageSize;
        int endIndex = (pageNo + 1) * pageSize - 1;
        ArrayList<AccDeviceEventSelectItem> data = new ArrayList<AccDeviceEventSelectItem>();
        int i = beginIndex;
        while (i <= endIndex) {
            if (items.size() <= i) break;
            data.add((AccDeviceEventSelectItem)items.get(i));
            ++i;
        }
        pager.setPage(pageNo);
        pager.setSize(pageSize);
        pager.setTotal(items.size());
        pager.setData(data);
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

