/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.acc.remote.AccDSTimeRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDSTimeService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.vo.AccDSTimeItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccDSTimeController
extends BaseController
implements AccDSTimeRemote {
    @Autowired
    private AccDSTimeService accDSTimeService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"acc:dSTime"})
    public ModelAndView index() {
        return new ModelAndView("acc/dSTime/accDSTime");
    }

    @RequiresPermissions(value={"acc:dSTime:add", "acc:dSTime:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("tempAccDSTime", (Object)this.accDSTimeService.getItemById(id));
        }
        return new ModelAndView("acc/dSTime/editAccDSTime");
    }

    @RequiresPermissions(value={"acc:dSTime:add", "acc:dSTime:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_dSTime", opType="common_op_edit", requestParams={"name"}, opContent="common_dsTime_name")
    public ZKResultMsg save(AccDSTimeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accDSTimeService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:dSTime:refresh"})
    public DxGrid list(AccDSTimeItem codition) {
        Pager pager = this.accDSTimeService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:dSTime:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_dSTime", opType="common_op_del", requestParams={"name"}, opContent="common_dsTime_name")
    public ZKResultMsg del(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (this.accDeviceService.getCountByDSTimeId(ids) > 0) {
            resultMsg.setRet("500");
            resultMsg.setMsg("common_dsTime_delete");
        } else {
            this.accDSTimeService.deleteByIds(ids);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg getDSTimeList() {
        ArrayList selectItemList = Lists.newArrayList();
        List accDSTimeItemList = this.accDSTimeService.getByCondition(new AccDSTimeItem());
        accDSTimeItemList.stream().forEach(dstime -> selectItemList.add(new SelectItem((Object)dstime.getName(), dstime.getId())));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)selectItemList));
    }

    public boolean isExistName(String name) {
        return this.accDSTimeService.isExistName(name);
    }

    @RequiresPermissions(value={"acc:dSTime:setDSTime"})
    public ModelAndView getById(String id) {
        this.request.setAttribute("id", (Object)id);
        return new ModelAndView("acc/dSTime/opAccSetDSTime");
    }

    @RequiresPermissions(value={"acc:dSTime:setDSTime"})
    public ZKResultMsg setDSTime(String dSTimeId, String devIds) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])) + "<br/>");
        List accDeviceItemList = this.accDeviceService.getItemByIds(devIds);
        int i = 0;
        while (i < accDeviceItemList.size()) {
            String devAlias = this.accDSTimeService.setDSTime(dSTimeId, ((AccDeviceItem)accDeviceItemList.get(i)).getId());
            this.progressCache.setProcess(new ProcessBean(100, (int)((float)(i + 1) / (float)accDeviceItemList.size() * 100.0f), String.valueOf(devAlias) + ":" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/>"));
            ++i;
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg getDSTimeListByTimeZone(String timeZone) {
        ZKResultMsg res = ZKResultMsg.successMsg();
        if (StringUtils.isNotBlank((CharSequence)timeZone)) {
            AccDSTimeItem condition = new AccDSTimeItem();
            condition.setTimeZone(timeZone);
            List items = this.accDSTimeService.getByCondition(condition);
            for (AccDSTimeItem item : items) {
                item.setName(I18nUtil.i18nCode((String)item.getName(), (Object[])new Object[0]));
            }
            res.setData((Object)items);
        } else {
            res.setData(new ArrayList());
        }
        return res;
    }

    public ZKResultMsg hasDSTimeByTimeZone(String timeZone) {
        ZKResultMsg res = ZKResultMsg.successMsg();
        if (StringUtils.isNotBlank((CharSequence)timeZone)) {
            res.setData(this.accDSTimeService.isExistByTimeZone(timeZone));
        } else {
            res.setData((Object)false);
        }
        return res;
    }

    public ModelAndView getDSTimeSelectView(String timeZone, String dsTime) {
        this.request.setAttribute("dsTime", (Object)dsTime);
        this.request.setAttribute("timeZone", (Object)timeZone);
        this.request.setAttribute("editPage", (Object)true);
        return new ModelAndView("acc/dSTime/selectDSTime");
    }
}

