/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccCombOpenPersonRemote;
import com.zkteco.zkbiosecurity.acc.service.AccCombOpenPersonService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonService;
import com.zkteco.zkbiosecurity.acc.vo.AccCombOpenPersonItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonCombOpenPersonItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccCombOpenPersonController
extends BaseController
implements AccCombOpenPersonRemote {
    @Autowired
    private AccCombOpenPersonService accCombOpenPersonService;
    @Autowired
    private AccPersonService accPersonService;

    @RequiresPermissions(value={"acc:combOpenPerson"})
    public ModelAndView index() {
        return new ModelAndView("acc/combOpenPerson/accCombOpenPerson");
    }

    @RequiresPermissions(value={"acc:combOpenPerson:add", "acc:combOpenPerson:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accCombOpenPersonService.getItemById(id));
        }
        return new ModelAndView("acc/combOpenPerson/editAccCombOpenPerson");
    }

    @RequiresPermissions(value={"acc:combOpenPerson:add", "acc:combOpenPerson:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_personGroup", opType="common_op_edit", requestParams={"name"}, opContent="acc_combOpen_personGroupName")
    public ZKResultMsg save(AccCombOpenPersonItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accCombOpenPersonService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:combOpenPerson:refresh"})
    public DxGrid list(AccCombOpenPersonItem codition) {
        Pager pager = this.accCombOpenPersonService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:combOpenPerson:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_personGroup", opType="common_op_del", requestParams={"names"}, opContent="acc_combOpen_personGroupName")
    public ZKResultMsg del(String ids) {
        this.accCombOpenPersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String valid(String name) {
        AccCombOpenPersonItem item = this.accCombOpenPersonService.getItemByName(name);
        boolean rs = item == null;
        return String.valueOf(rs);
    }

    public ZKResultMsg getCombOpenJsonData() {
        ZKResultMsg zkResultMsg = this.accCombOpenPersonService.getCombOpenJsonData();
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg checkPersonCount(String groupId) {
        ZKResultMsg zkResultMsg = this.accCombOpenPersonService.checkPersonCount(groupId);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"acc:combOpenPerson:addPerson"})
    @LogRequest(module="acc_module", object="acc_leftMenu_personGroup", opType="pers_common_addPerson", requestParams={"combOpenName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg addPerson(String combOpenPersonId, String personIds, String deptIds) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.accPersonService.getPersonIdsByDeptIds(deptIds);
        }
        if (StringUtils.isNotBlank((CharSequence)combOpenPersonId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            ArrayList<String> personIdList = new ArrayList<String>(Arrays.asList(personIds.split(",")));
            List existPersonIds = this.accCombOpenPersonService.getExistPersonIds();
            if (existPersonIds.size() > 0) {
                personIdList.removeAll(existPersonIds);
            }
            zkResultMsg = this.accCombOpenPersonService.addPerson(combOpenPersonId, personIdList);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"acc:combOpenPerson:delPerson"})
    @LogRequest(module="acc_module", object="acc_leftMenu_personGroup", opType="pers_common_delPerson", requestParams={"combOpenName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg delPerson(String combOpenId, String personIds) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.accCombOpenPersonService.delPerson(combOpenId, personIds));
    }

    @RequiresPermissions(value={"acc:combOpenPerson:refresh"})
    public DxGrid personList(AccPersonCombOpenPersonItem condition) {
        Pager pager = this.accPersonService.getCombOpenPersonItemList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getCombOpenList() {
        return new ZKResultMsg((Object)this.accCombOpenPersonService.getCombOpenList());
    }
}

