/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccAuxOutRemote;
import com.zkteco.zkbiosecurity.acc.service.AccAuxOutService;
import com.zkteco.zkbiosecurity.acc.service.AccTimeSegService;
import com.zkteco.zkbiosecurity.acc.vo.AccAuxOutItem;
import com.zkteco.zkbiosecurity.acc.vo.AccTimeSegItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccAuxOutController
extends BaseController
implements AccAuxOutRemote {
    @Autowired
    private AccAuxOutService accAuxOutService;
    @Autowired
    private AccTimeSegService accTimeSegService;

    @RequiresPermissions(value={"acc:auxOut"})
    public ModelAndView index() {
        return new ModelAndView("acc/auxOut/accAuxOut");
    }

    @RequiresPermissions(value={"acc:auxOut:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AccAuxOutItem item = this.accAuxOutService.getItemById(id);
            boolean outRelaySetFunOn = this.accAuxOutService.isSupportOutRelaySet(item.getDevSn());
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("outRelaySetFunOn", (Object)outRelaySetFunOn);
        }
        return new ModelAndView("acc/auxOut/editAccAuxOut");
    }

    @RequiresPermissions(value={"acc:auxOut:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_auxOut", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(AccAuxOutItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accAuxOutService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:auxOut:refresh"})
    public DxGrid list(AccAuxOutItem codition) {
        Pager pager = this.accAuxOutService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        List accAuxOutItems = pager.getData();
        accAuxOutItems.stream().filter(item -> item.getAccTimeSegId() != null).forEach(accAuxOutItem -> {
            AccTimeSegItem accTimeSegItem = this.accTimeSegService.getItemById(accAuxOutItem.getAccTimeSegId());
            accAuxOutItem.setAccTimeSegName(accTimeSegItem.getName());
        });
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:auxOut:del"})
    public ZKResultMsg del(String ids) {
        this.accAuxOutService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:auxOut:openAuxOut", "acc:auxOut:closeAuxOut", "acc:auxOut:normalOpen"})
    public ModelAndView getAuxOutIds(String type, String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        Map retMap = this.accAuxOutService.getAuxOutIds(idList);
        this.request.setAttribute("retIds", retMap.containsKey("retIds") ? retMap.get("retIds") : "");
        this.request.setAttribute("auxOutsName", retMap.containsKey("auxOutsName") ? retMap.get("auxOutsName") : "");
        this.request.setAttribute("disabledAuxOutsName", retMap.containsKey("disabledAuxOutsName") ? retMap.get("disabledAuxOutsName") : "");
        this.request.setAttribute("offlineAuxOutsName", retMap.containsKey("offlineAuxOutsName") ? retMap.get("offlineAuxOutsName") : "");
        this.request.setAttribute("type", (Object)type);
        this.request.setAttribute("name", retMap.containsKey("auxOutNames") ? retMap.get("auxOutNames") : "");
        return new ModelAndView("/acc/auxOut/opAccAuxOut");
    }

    public boolean isExist(AccAuxOutItem item) {
        return this.accAuxOutService.isExist(item);
    }
}

