/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccAuxInRemote;
import com.zkteco.zkbiosecurity.acc.service.AccAuxInService;
import com.zkteco.zkbiosecurity.acc.service.AccChannelService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceOptionService;
import com.zkteco.zkbiosecurity.acc.vo.AccAuxInItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccAuxInController
extends BaseController
implements AccAuxInRemote {
    @Autowired
    private AccAuxInService accAuxInService;
    @Autowired
    private AccDeviceOptionService accDeviceOptionService;
    @Autowired
    private AccChannelService accChannelService;

    @RequiresPermissions(value={"acc:auxIn"})
    public ModelAndView index() {
        return new ModelAndView("acc/auxIn/accAuxIn");
    }

    @RequiresPermissions(value={"acc:auxIn:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AccAuxInItem accAuxInItem = this.accAuxInService.getItemById(id);
            this.request.setAttribute("item", (Object)accAuxInItem);
            if (this.accDeviceOptionService.getAccSupportFunListVal(accAuxInItem.getDevId(), 8)) {
                this.request.setAttribute("supportAuxInTimezone", (Object)true);
            }
        }
        return new ModelAndView("acc/auxIn/editAccAuxIn");
    }

    @RequiresPermissions(value={"acc:auxIn:edit"})
    @LogRequest(module="acc_module", object="common_leftMenu_auxIn", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(AccAuxInItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accAuxInService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:auxIn:refresh"})
    public DxGrid list(AccAuxInItem codition) {
        Pager pager = this.accAuxInService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:auxIn:del"})
    public ZKResultMsg del(String ids) {
        this.accAuxInService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExist(AccAuxInItem item) {
        return this.accAuxInService.isExist(item);
    }

    public ModelAndView getChannelByEntityId() {
        String entityId = this.request.getParameter("entityId");
        this.request.setAttribute("entityId", (Object)entityId);
        this.request.setAttribute("entityName", (Object)"AccAuxIn");
        String channel2EntityIds = this.accChannelService.getBindChannelIds(Arrays.asList(entityId), "AccAuxIn");
        this.request.setAttribute("value", (Object)channel2EntityIds);
        return new ModelAndView("acc/auxIn/accAuxInSelectChannelContent");
    }

    @RequiresPermissions(value={"acc:auxIn:bindChannel"})
    @LogRequest(module="acc_module", object="common_leftMenu_auxIn", opType="common_vid_bindOrUnbindChannel", requestParams={}, opContent="common_vid_bindOrUnbindChannel")
    public ZKResultMsg bindOrUnbindChannel() {
        String entityId = this.request.getParameter("entityId");
        String entityName = this.request.getParameter("entityName");
        String channelIds = this.request.getParameter("channelIds");
        ZKResultMsg ret = this.accChannelService.bindOrUnbindChannel(channelIds, entityName, entityId);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }
}

