/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.constants.AccConstants;
import com.zkteco.zkbiosecurity.acc.remote.AccAntiPassbackRemote;
import com.zkteco.zkbiosecurity.acc.service.AccAntiPassbackService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceOptionService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.vo.AccAntiPassbackItem;
import com.zkteco.zkbiosecurity.acc.vo.AccAntiPassbackSelectDeviceItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceOptionItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccAntiPassbackController
extends BaseController
implements AccAntiPassbackRemote {
    @Autowired
    private AccAntiPassbackService accAntiPassbackService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccDeviceOptionService accDeviceOptionService;

    @RequiresPermissions(value={"acc:antiPassback"})
    public ModelAndView index() {
        return new ModelAndView("acc/antiPassback/accAntiPassback");
    }

    @RequiresPermissions(value={"acc:antiPassback:add", "acc:antiPassback:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accAntiPassbackService.getItemById(id));
        }
        return new ModelAndView("acc/antiPassback/editAccAntiPassback");
    }

    @RequiresPermissions(value={"acc:antiPassback:add", "acc:antiPassback:edit"})
    @LogRequest(module="acc_module", object="acc_eventNo_24", opType="common_op_edit", requestParams={"deviceName"}, opContent="common_dev_name")
    public ZKResultMsg save(AccAntiPassbackItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accAntiPassbackService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:antiPassback:refresh"})
    public DxGrid list(AccAntiPassbackItem codition) {
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.accAntiPassbackService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        List accAntiPassbackItemList = pager.getData();
        accAntiPassbackItemList.forEach(accAntiPassbackItem -> accAntiPassbackItem.setApbRuleShow(this.accAntiPassbackService.convertAntiPassbackRule(accAntiPassbackItem.getId())));
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:antiPassback:del"})
    @LogRequest(module="acc_module", object="acc_eventNo_24", opType="common_op_del", requestParams={"deviceNames"}, opContent="common_dev_name")
    public ZKResultMsg del(String ids) {
        this.accAntiPassbackService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getRule(String deviceId) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        AccDeviceItem dev = this.accDeviceService.getItemById(deviceId);
        Map map = this.accAntiPassbackService.getApbRule(deviceId);
        Map doorMap = (Map)map.get("doorMap");
        Integer readerCount = (Integer)map.get("readerCount");
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        if (doorMap != null && doorMap.size() > 0) {
            String rule = "";
            AccDeviceOptionItem accDeviceOptionItem = new AccDeviceOptionItem(deviceId, "AccSupportFunList");
            List accDeviceOptionItemList = this.accDeviceOptionService.getByCondition(accDeviceOptionItem);
            if (accDeviceOptionItemList != null && accDeviceOptionItemList.size() > 0 && (10 == dev.getMachineType() || 2 == dev.getMachineType() || 28 == dev.getMachineType() || 25 == dev.getMachineType())) {
                rule = I18nUtil.i18nCode((String)"acc_apb_reader7", (Object[])new Object[0]);
                selectItemList.add(this.getJsonObj("7", rule));
            }
            if (101 == dev.getMachineType()) {
                rule = String.format(I18nUtil.i18nCode((String)"acc_apb_controlOut", (Object[])new Object[0]), doorMap.get(1));
                selectItemList.add(this.getJsonObj("1", rule));
                rule = String.format(I18nUtil.i18nCode((String)"acc_apb_controlIn", (Object[])new Object[0]), doorMap.get(1));
                selectItemList.add(this.getJsonObj("2", rule));
                rule = String.format(I18nUtil.i18nCode((String)"acc_apb_controlInOut", (Object[])new Object[0]), doorMap.get(1));
                selectItemList.add(this.getJsonObj("3", rule));
            } else if (doorMap.size() == AccConstants.ACPANEL_1_DOOR.shortValue()) {
                rule = I18nUtil.i18nCode((String)"acc_apb_reader", (Object[])new Object[]{doorMap.get(1)});
                selectItemList.add(this.getJsonObj("1", rule));
            } else if (doorMap.size() == AccConstants.ACPANEL_2_DOOR.shortValue() && readerCount == 4 || dev.getMachineType() == 5) {
                rule = I18nUtil.i18nCode((String)"acc_apb_reader", (Object[])new Object[]{doorMap.get(1)});
                selectItemList.add(this.getJsonObj("1", rule));
                rule = I18nUtil.i18nCode((String)"acc_apb_reader", (Object[])new Object[]{doorMap.get(2)});
                selectItemList.add(this.getJsonObj("2", rule));
                rule = I18nUtil.i18nCode((String)"acc_apb_reader2", (Object[])new Object[]{doorMap.get(1), doorMap.get(2)});
                selectItemList.add(this.getJsonObj("3", rule));
                rule = I18nUtil.i18nCode((String)"acc_apb_twoDoor", (Object[])new Object[]{doorMap.get(1), doorMap.get(2)});
                selectItemList.add(this.getJsonObj("4", rule));
            } else if (doorMap.size() == AccConstants.ACPANEL_2_DOOR.shortValue() && readerCount == 2) {
                rule = I18nUtil.i18nCode((String)"acc_apb_reader", (Object[])new Object[]{doorMap.get(1)});
                selectItemList.add(this.getJsonObj("16", rule));
                rule = I18nUtil.i18nCode((String)"acc_apb_reader", (Object[])new Object[]{doorMap.get(2)});
                selectItemList.add(this.getJsonObj("32", rule));
                rule = I18nUtil.i18nCode((String)"acc_apb_reader2", (Object[])new Object[]{doorMap.get(1), doorMap.get(2)});
                selectItemList.add(this.getJsonObj("48", rule));
                rule = I18nUtil.i18nCode((String)"acc_apb_twoDoor", (Object[])new Object[]{doorMap.get(1), doorMap.get(2)});
                selectItemList.add(this.getJsonObj("1", rule));
            } else if (doorMap.size() == AccConstants.ACPANEL_4_DOOR.shortValue()) {
                rule = I18nUtil.i18nCode((String)"acc_apb_twoDoor", (Object[])new Object[]{doorMap.get(1), doorMap.get(2)});
                selectItemList.add(this.getJsonObj("1", rule));
                rule = I18nUtil.i18nCode((String)"acc_apb_twoDoor", (Object[])new Object[]{doorMap.get(3), doorMap.get(4)});
                selectItemList.add(this.getJsonObj("2", rule));
                rule = I18nUtil.i18nCode((String)"acc_apb_fourDoor", (Object[])new Object[]{doorMap.get(1), doorMap.get(2), doorMap.get(3), doorMap.get(4)});
                selectItemList.add(this.getJsonObj("3", rule));
                rule = I18nUtil.i18nCode((String)"acc_apb_fourDoor2", (Object[])new Object[]{doorMap.get(1), doorMap.get(2), doorMap.get(3), doorMap.get(4)});
                selectItemList.add(this.getJsonObj("4", rule));
                rule = I18nUtil.i18nCode((String)"acc_apb_fourDoor3", (Object[])new Object[]{doorMap.get(1), doorMap.get(2), doorMap.get(3), doorMap.get(4)});
                selectItemList.add(this.getJsonObj("5", rule));
                rule = I18nUtil.i18nCode((String)"acc_apb_fourDoor4", (Object[])new Object[]{doorMap.get(1), doorMap.get(2), doorMap.get(3), doorMap.get(4)});
                selectItemList.add(this.getJsonObj("6", rule));
                if (this.accDeviceOptionService.isSupportFun(dev.getSn(), "~Ext485ReaderFunOn")) {
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader", (Object[])new Object[]{doorMap.get(1)});
                    selectItemList.add(this.getJsonObj("16", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader", (Object[])new Object[]{doorMap.get(2)});
                    selectItemList.add(this.getJsonObj("32", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader", (Object[])new Object[]{doorMap.get(3)});
                    selectItemList.add(this.getJsonObj("64", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader", (Object[])new Object[]{doorMap.get(4)});
                    selectItemList.add(this.getJsonObj("128", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader2", (Object[])new Object[]{doorMap.get(1), doorMap.get(2)});
                    selectItemList.add(this.getJsonObj("48", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader2", (Object[])new Object[]{doorMap.get(1), doorMap.get(3)});
                    selectItemList.add(this.getJsonObj("80", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader2", (Object[])new Object[]{doorMap.get(1), doorMap.get(4)});
                    selectItemList.add(this.getJsonObj("144", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader2", (Object[])new Object[]{doorMap.get(2), doorMap.get(3)});
                    selectItemList.add(this.getJsonObj("96", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader2", (Object[])new Object[]{doorMap.get(2), doorMap.get(4)});
                    selectItemList.add(this.getJsonObj("160", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader2", (Object[])new Object[]{doorMap.get(3), doorMap.get(4)});
                    selectItemList.add(this.getJsonObj("196", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader3", (Object[])new Object[]{doorMap.get(1), doorMap.get(2), doorMap.get(3)});
                    selectItemList.add(this.getJsonObj("112", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader3", (Object[])new Object[]{doorMap.get(1), doorMap.get(2), doorMap.get(4)});
                    selectItemList.add(this.getJsonObj("176", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader3", (Object[])new Object[]{doorMap.get(1), doorMap.get(3), doorMap.get(4)});
                    selectItemList.add(this.getJsonObj("208", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader3", (Object[])new Object[]{doorMap.get(2), doorMap.get(3), doorMap.get(4)});
                    selectItemList.add(this.getJsonObj("224", rule));
                    rule = I18nUtil.i18nCode((String)"acc_apb_reader4", (Object[])new Object[]{doorMap.get(1), doorMap.get(2), doorMap.get(3), doorMap.get(4)});
                    selectItemList.add(this.getJsonObj("240", rule));
                }
            }
        }
        zkResultMsg.setData(selectItemList);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg validGlobalApb(String devId) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        Boolean setGlobalApb = this.accAntiPassbackService.validGlobalApb(devId);
        zkResultMsg.setData((Object)setGlobalApb);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public DxGrid selectDevicelist(AccAntiPassbackSelectDeviceItem codition) {
        String filterDevId = this.accAntiPassbackService.getDevIdWithApb();
        if (StringUtils.isBlank((CharSequence)codition.getSelectId())) {
            codition.setSelectId("-1");
        }
        if (codition.getType().equals("noSelected")) {
            if (StringUtils.isNotBlank((CharSequence)filterDevId)) {
                filterDevId = String.valueOf(codition.getSelectId()) + "," + filterDevId;
                codition.setSelectId(filterDevId);
            }
            codition.setSelectDeviceIdsNotIn(codition.getSelectId());
        } else if (codition.getType().equals("selected")) {
            codition.setSelectDeviceIdsIn(codition.getSelectId());
        }
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.accDeviceService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    private SelectItem getJsonObj(String val, String name) {
        SelectItem selectItem = new SelectItem();
        selectItem.setValue(val);
        selectItem.setText((Object)name);
        return selectItem;
    }
}

