/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccAlarmMonitorReportRemote;
import com.zkteco.zkbiosecurity.acc.service.AccAlarmMonitorService;
import com.zkteco.zkbiosecurity.acc.service.AccTransactionService;
import com.zkteco.zkbiosecurity.acc.vo.AccAlarmMonitorItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccAlarmMonitorReportController
extends ExportController
implements AccAlarmMonitorReportRemote {
    @Autowired
    private AccAlarmMonitorService accAlarmMonitorService;
    @Autowired
    private AccTransactionService accTransactionService;

    @RequiresPermissions(value={"acc:alarmReport"})
    public ModelAndView index() {
        return new ModelAndView("acc/alarmMonitor/accAlarmMonitorReport");
    }

    @RequiresPermissions(value={"acc:alarmReport:refresh"})
    public DxGrid list(AccAlarmMonitorItem accAlarmMonitorItem) {
        long limit = this.getLimitCount();
        accAlarmMonitorItem.setAreaNameIn(this.accTransactionService.getAreaNamesBySessionId(this.request.getSession().getId()));
        Pager pager = this.accAlarmMonitorService.getPager((BaseItem)accAlarmMonitorItem, this.getPageNo(), this.getPageSize(), limit);
        return GridUtil.convert((Pager)pager, accAlarmMonitorItem.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"acc:alarmReport"})
    @LogRequest(module="acc_module", object="acc_rtMonitor_ackAlarm", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AccAlarmMonitorItem item = new AccAlarmMonitorItem();
        this.setConditionValue((BaseItem)item);
        List items = this.accAlarmMonitorService.getItemData(AccAlarmMonitorItem.class, (BaseItem)item, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(items, AccAlarmMonitorItem.class);
    }

    public ModelAndView editAcknowledged(String ids) {
        this.request.setAttribute("id", (Object)ids);
        this.request.setAttribute("description", (Object)this.accAlarmMonitorService.getDescription(ids));
        this.request.setAttribute("editPage", (Object)false);
        return new ModelAndView("acc/alarmMonitor/editAcknowledged");
    }
}

