/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.remote.AccAlarmMonitorRemote;
import com.zkteco.zkbiosecurity.acc.service.AccAlarmMonitorService;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccTransactionService;
import com.zkteco.zkbiosecurity.acc.vo.AccAlarmMonitorHistoryItem;
import com.zkteco.zkbiosecurity.acc.vo.AccAlarmMonitorItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccAlarmMonitorController
extends ExportController
implements AccAlarmMonitorRemote {
    @Autowired
    private AccAlarmMonitorService accAlarmMonitorService;
    @Autowired
    private AccTransactionService accTransactionService;
    @Autowired
    private AccLevelService accLevelService;

    @RequiresPermissions(value={"acc:alarmMonitor"})
    public ModelAndView index() {
        return new ModelAndView("acc/alarmMonitor/accAlarmMonitor");
    }

    public ZKResultMsg ackAlarm(String key) {
        this.accAlarmMonitorService.checkAlarmMonitor(key);
        this.accAlarmMonitorService.sendAllAlarmMonitorWS(false);
        return new ZKResultMsg();
    }

    public ZKResultMsg receiveNewMessagesRequest() {
        this.accAlarmMonitorService.sendAllAlarmMonitorWS(false);
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg getDataByEventNum(Map filters) {
        filters.put("sessionId", this.request.getSession().getId());
        List dataList = this.accAlarmMonitorService.getDataByEventNum(filters);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("alarm", (Object)this.accAlarmMonitorService.createJsonFromItems(dataList));
        jsonObject.put("analysis", (Object)this.accAlarmMonitorService.getAnalysisByAuthFilter(this.request.getSession().getId()));
        return new ZKResultMsg((Object)jsonObject);
    }

    public ZKResultMsg getFirstPage(Map filters) {
        filters.put("sessionId", this.request.getSession().getId());
        List dataList = this.accAlarmMonitorService.getFirstPage(filters);
        return new ZKResultMsg((Object)this.accAlarmMonitorService.createJsonFromItems(dataList));
    }

    public ZKResultMsg getInfoByPageNo(Map filters) {
        Integer pageNo = Integer.valueOf("" + filters.get("pageNo"));
        Integer targetNum = Integer.valueOf("" + filters.get("targetNum"));
        filters.put("sessionId", this.request.getSession().getId());
        List dataList = this.accAlarmMonitorService.getNotAcknowledgedItemByPage(filters, pageNo.intValue(), (long)targetNum.intValue());
        return new ZKResultMsg((Object)this.accAlarmMonitorService.createJsonFromItems(dataList));
    }

    @RequiresPermissions(value={"acc:alarmMonitor:ackAlarm"})
    public ModelAndView editAcknowledged(String id) {
        this.request.setAttribute("id", (Object)id);
        this.request.setAttribute("description", (Object)this.accAlarmMonitorService.getDescription(id));
        this.request.setAttribute("editPage", (Object)false);
        return new ModelAndView("acc/alarmMonitor/editAcknowledged");
    }

    @LogRequest(module="acc_module", object="acc_rtMonitor_alarmMonitor", opType="acc_rtMonitor_ackAlarm", requestParams={"id"}, opContent="common_number")
    public ZKResultMsg editStatus(String id, Short status, String acknowledgement, Boolean sendEmail, String emails) {
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                boolean ret = this.accLevelService.verifyLoginPwd(this.request.getSession().getId(), loginPwd);
                if (!ret) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        this.accAlarmMonitorService.changeStatus(id, status, acknowledgement);
        ZKResultMsg res = ZKResultMsg.successMsg();
        if (status == 2) {
            res.setData((Object)id);
        }
        return res;
    }

    @RequiresPermissions(value={"acc:alarmMonitor:history"})
    public ModelAndView showHistory(String id) {
        AccAlarmMonitorItem item = this.accAlarmMonitorService.getById(id);
        item.setEventName(I18nUtil.i18nCode((String)item.getEventName(), (Object[])new Object[0]));
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("acc/alarmMonitor/showHistory");
    }

    @RequiresPermissions(value={"acc:alarmHistory"})
    public ModelAndView history() {
        return new ModelAndView("acc/alarmMonitor/alarmHistory");
    }

    @RequiresPermissions(value={"acc:alarmHistory:refresh"})
    public DxGrid historyList(AccAlarmMonitorHistoryItem condition) {
        long limit = this.getLimitCount();
        String areaNames = this.accTransactionService.getAreaNamesBySessionId(this.request.getSession().getId());
        condition.setAreaNameIn(areaNames);
        Pager pager = this.accAlarmMonitorService.getHistoryByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), limit);
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"acc:alarmHistory:clear"})
    @LogRequest(module="acc_module", object="acc_alarm_history", opType="common_search_clear", opContent="common_search_clear")
    public ZKResultMsg clearHistoryData() {
        return this.accAlarmMonitorService.clearHistoryData();
    }

    @RequiresPermissions(value={"acc:alarmHistory:export"})
    @LogRequest(module="acc_module", object="acc_alarm_history", opType="common_op_export", opContent="common_op_export")
    public void exportHistory(HttpServletRequest request, HttpServletResponse response) {
        AccAlarmMonitorHistoryItem historyItem = new AccAlarmMonitorHistoryItem();
        this.setConditionValue((BaseItem)historyItem);
        List itemList = this.accAlarmMonitorService.getHistoryData(AccAlarmMonitorHistoryItem.class, (BaseItem)historyItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AccAlarmMonitorHistoryItem.class);
    }
}

