/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.app.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.app.vo.AccAppDoorItem;
import com.zkteco.zkbiosecurity.acc.service.AccAppService;
import com.zkteco.zkbiosecurity.acc.utils.AccEnumUtil;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceItem;
import com.zkteco.zkbiosecurity.acc.vo.AccLevelItem;
import com.zkteco.zkbiosecurity.base.vo.AppResultMessage;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/v2/acc"})
public class AccAppV2Controller {
    @Autowired
    private AccAppService accAppService;
    @Autowired
    protected HttpServletRequest request;

    @RequestMapping(value={"/getReportByFilters"}, method={RequestMethod.POST})
    public AppResultMessage getReportByFilters(@RequestBody JSONObject data) {
        String userName = this.request.getParameter("user_name");
        String userId = this.request.getParameter("user_id");
        int pageNo = data.containsKey((Object)"pageNo") ? data.getIntValue("pageNo") : 1;
        int pageSize = data.containsKey((Object)"pageSize") ? data.getIntValue("pageSize") : 20;
        String filters = data.getString("filters");
        Date startTime = data.containsKey((Object)"startTime") ? data.getDate("startTime") : null;
        Date endTime = data.containsKey((Object)"endTime") ? data.getDate("endTime") : null;
        String eventNo = data.getString("eventNo");
        String doorId = data.getString("doorId");
        String loginType = data.getString("loginType");
        return this.accAppService.getReportByFilters(doorId, filters, startTime, endTime, pageNo, pageSize, userName, userId, loginType, eventNo);
    }

    @RequestMapping(value={"/getReportDetail"}, method={RequestMethod.POST})
    public AppResultMessage getReportDetail(@RequestBody JSONObject data) {
        String id = data.getString("id");
        return this.accAppService.getReportDetail(id);
    }

    @RequestMapping(value={"/getAccDeviceCount"}, method={RequestMethod.POST})
    public AppResultMessage getAccDeviceCount(@RequestBody JSONObject data) {
        String areaIds = data.getString("areaIds");
        return this.accAppService.getAccDeviceCount(areaIds);
    }

    @RequestMapping(value={"/getAccDevices"}, method={RequestMethod.POST})
    public AppResultMessage getAccDevices(@RequestBody JSONObject data) {
        String areaIds = data.getString("areaIds");
        String state = data.getString("state");
        int pageNo = data.containsKey((Object)"pageNo") ? data.getIntValue("pageNo") : 1;
        int pageSize = data.containsKey((Object)"pageSize") ? data.getIntValue("pageSize") : 20;
        AccDeviceItem condition = new AccDeviceItem();
        condition.setAreaIdIn(areaIds);
        if (StringUtils.isNotBlank((CharSequence)state)) {
            condition.setConnectState(state);
        }
        String userName = this.request.getParameter("user_name");
        return this.accAppService.getAccDevicesPager(condition, pageNo - 1, pageSize, userName);
    }

    @RequestMapping(value={"/getAccLevels"}, method={RequestMethod.POST})
    public AppResultMessage getAccLevels(@RequestBody JSONObject data) {
        String userName = this.request.getParameter("user_name");
        String name = data.containsKey((Object)"name") ? data.getString("name") : "";
        int pageNo = data.containsKey((Object)"pageNo") ? data.getIntValue("pageNo") : 1;
        int pageSize = data.containsKey((Object)"pageSize") ? data.getIntValue("pageSize") : 20;
        AccLevelItem codition = new AccLevelItem();
        String areaIds = data.containsKey((Object)"areaIds") ? data.getString("areaIds") : "";
        codition.setName(name);
        codition.setAreaIds(areaIds);
        return this.accAppService.loadPagerByAuthFilter(userName, codition, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/operateDoorByLevel"}, method={RequestMethod.POST})
    public AppResultMessage operateDoor(@RequestBody JSONObject data) {
        String levelIds = data.getString("levelIds");
        String type = data.getString("type");
        String interval = data.getString("interval");
        String userName = this.request.getParameter("user_name");
        return this.accAppService.operateDoorByLevel(userName, type, interval, levelIds);
    }

    @RequestMapping(value={"/getAllDoor"}, method={RequestMethod.POST})
    public AppResultMessage getAllDoor(@RequestBody JSONObject data) {
        JSONObject doorJson;
        JSONArray doorArray;
        String token = data.getString("token");
        String doorName = data.getString("doorName");
        Short doorStatus = data.getShort("doorStatus");
        String loginType = data.getString("loginType");
        AppResultMessage appResultMessage = this.accAppService.getDoorByDoorName(token, doorName, 1, 2000, loginType);
        ArrayList<AccAppDoorItem> accAppDoorItemList = new ArrayList<AccAppDoorItem>();
        JSONObject dataJson = new JSONObject();
        if (appResultMessage.getData() != null && (doorArray = (doorJson = (JSONObject)appResultMessage.getData()).getJSONArray("rows")).size() > 0) {
            int i = 0;
            while (doorArray.size() > i) {
                JSONObject door = doorArray.getJSONObject(i);
                AccAppDoorItem appDoor = new AccAppDoorItem();
                appDoor.setId(door.getString("id"));
                appDoor.setDoorName(door.getString("name"));
                appDoor.setDevName(door.getString("devName"));
                appDoor.setTimeZone(door.getString("timeZone"));
                appDoor.setAreaName(door.containsKey((Object)"areaName") ? door.getString("areaName") : null);
                appDoor.setRelay(door.getString("relay"));
                appDoor.setSensor(door.getString("sensor"));
                appDoor.setDoorStatus(door.getShortValue("connect"));
                if (1 == door.getShortValue("connect")) {
                    if (AccEnumUtil.Alarm.getAlarmType(door.getIntValue("alarmLevel"), door.getIntValue("alarm")) == 0) {
                        appDoor.setDoorAlarmStatus(Integer.valueOf(0));
                    } else {
                        appDoor.setAlarm(Integer.valueOf(AccEnumUtil.Alarm.getAlarmType(door.getIntValue("alarmLevel"), door.getIntValue("alarm"))));
                        appDoor.setDoorAlarmStatus(Integer.valueOf(1));
                    }
                    if (3 == door.getIntValue("doorValue")) {
                        appDoor.setDoorStatus((short)3);
                    }
                } else if (2 == door.getShortValue("connect")) {
                    appDoor.setDoorAlarmStatus(Integer.valueOf(2));
                } else if (door.getShortValue("connect") == 0) {
                    appDoor.setDoorAlarmStatus(Integer.valueOf(3));
                }
                if (doorStatus == null) {
                    accAppDoorItemList.add(appDoor);
                } else if (doorStatus.equals(appDoor.getDoorStatus())) {
                    accAppDoorItemList.add(appDoor);
                }
                ++i;
            }
        }
        dataJson.put("totalCount", (Object)accAppDoorItemList.size());
        dataJson.put("rows", accAppDoorItemList);
        appResultMessage.setData((Object)dataJson);
        return appResultMessage;
    }
}

