/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.api.controller;

import com.zkteco.zkbiosecurity.acc.service.AccTransactionService;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/v2/transaction"})
@Api(tags={"AccTransaction"}, description="acc transaction")
public class AccApiV2TransactionController {
    @Autowired
    private AccTransactionService accTransactionService;

    @ApiOperation(value="Get Transaction List By Sn", notes="Return Transactions", response=ApiResultMessage.class)
    @RequestMapping(value={"/device/{deviceSn}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getTransactionsByDeviceSn(@PathVariable(name="deviceSn") String deviceSn, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage apiResultMessage = this.checkParam(startDate, endDate, pageNo, pageSize);
        if (apiResultMessage != null) {
            return apiResultMessage;
        }
        if (StringUtils.isBlank((CharSequence)deviceSn)) {
            return ApiResultMessage.message((int)-48, (String)I18nUtil.i18nCode((String)"acc_api_devSnNotNull", (Object[])new Object[0]));
        }
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
        }
        Pager pager = this.accTransactionService.getAccApiTransactionsBySnAndPage(deviceSn, startTime, endTime, pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)pager);
    }

    @ApiOperation(value="Get Transaction List By Pin", notes="Return Transactions", response=ApiResultMessage.class)
    @RequestMapping(value={"/person/{pin}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getTransactionsByPin(@PathVariable(name="pin") String pin, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage apiResultMessage = this.checkParam(startDate, endDate, pageNo, pageSize);
        if (apiResultMessage != null) {
            return apiResultMessage;
        }
        if (StringUtils.isBlank((CharSequence)pin)) {
            return ApiResultMessage.message((int)-20, (String)I18nUtil.i18nCode((String)"pers_import_pinNotEmpty", (Object[])new Object[0]));
        }
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
        }
        Pager pager = this.accTransactionService.getAccApiTransactionsByPinAndPage(pin, startTime, endTime, pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)pager);
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Transactions List", notes="Return Transactions List", response=ApiResultMessage.class)
    public ApiResultMessage list(@RequestParam(name="personPin", required=false) String personPin, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage apiResultMessage = this.checkParam(startDate, endDate, pageNo, pageSize);
        if (apiResultMessage != null) {
            return apiResultMessage;
        }
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
        }
        Pager pager = this.accTransactionService.getAccApiTransactionListByPage(personPin, startTime, endTime, pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)pager);
    }

    private ApiResultMessage checkParam(String startDate, String endDate, Integer pageNo, Integer pageSize) {
        Date startTime = null;
        Date endTime = null;
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-91, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
            if (startTime == null || endTime == null) {
                return ApiResultMessage.message((int)-100, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid2", (Object[])new Object[0]));
            }
            if (startTime.getTime() > endTime.getTime()) {
                return ApiResultMessage.message((int)-101, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid4", (Object[])new Object[0]));
            }
        }
        return null;
    }

    @ApiOperation(value="Get FirstInAndLastOut List By Pin", notes="Return FirstInAndLastOut List", response=ApiResultMessage.class)
    @RequestMapping(value={"/firstInAndLastOut/{pin}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getFirstInLastOutByPin(@PathVariable(name="pin") String pin, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage apiResultMessage = this.checkParam(startDate, endDate, pageNo, pageSize);
        if (apiResultMessage != null) {
            return apiResultMessage;
        }
        if (StringUtils.isBlank((CharSequence)pin)) {
            return ApiResultMessage.message((int)-20, (String)I18nUtil.i18nCode((String)"pers_import_pinNotEmpty", (Object[])new Object[0]));
        }
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
        }
        Pager pager = this.accTransactionService.getAccApiFirstInLastOutByPinAndPage(pin, startTime, endTime, pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)pager);
    }

    @ApiOperation(value="Get Door Transactions List", notes="Return Transactions", response=ZKResultMsg.class)
    @RequestMapping(value={"/getDoorTransactions"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getDoorTransactions(@RequestBody ZKMessage zkMessage) {
        Integer pageSize;
        Map content = zkMessage.getContent();
        String devSn = MapUtils.getString((Map)content, (Object)"devSn");
        String startTime = MapUtils.getString((Map)content, (Object)"startTime");
        String endTime = MapUtils.getString((Map)content, (Object)"endTime");
        String filter = MapUtils.getString((Map)content, (Object)"filter");
        String type = MapUtils.getString((Map)content, (Object)"type");
        String eventNo = MapUtils.getString((Map)content, (Object)"eventNo");
        String personPin = MapUtils.getString((Map)content, (Object)"personPin");
        Integer pageNo = MapUtils.getInteger((Map)content, (Object)"pageNo");
        ZKResultMsg zkResultMsg = this.checkApiParam(startTime, endTime, pageNo, pageSize = MapUtils.getInteger((Map)content, (Object)"pageSize"));
        if (zkResultMsg != null) {
            return zkResultMsg;
        }
        Date startDate = null;
        Date endDate = null;
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            startDate = DateUtil.stringToDate((String)startTime);
            endDate = DateUtil.stringToDate((String)endTime);
        }
        if (StringUtils.isNotBlank((CharSequence)personPin)) {
            return this.accTransactionService.getBySnAndPinAndPage(devSn, personPin, startDate, endDate, pageNo, pageSize);
        }
        return this.accTransactionService.getByFilterAndTypeAndPage(devSn, filter, type, eventNo, startDate, endDate, pageNo, pageSize);
    }

    private ZKResultMsg checkApiParam(String startDate, String endDate, Integer pageNo, Integer pageSize) {
        Date startTime = null;
        Date endTime = null;
        if (pageNo < 0 || pageSize <= 0) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        if (pageSize > 1000) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
            if (startTime == null || endTime == null) {
                return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"common_dsTime_timeValid2", (Object[])new Object[0]), (Object[])new Object[0]);
            }
            if (startTime.getTime() > endTime.getTime()) {
                return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"common_dsTime_timeValid4", (Object[])new Object[0]), (Object[])new Object[0]);
            }
        }
        return null;
    }
}

