/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.api.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.acc.api.vo.AccApiLevelItem;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.vo.AccLevelItem;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/v2/accLevel"})
@Api(tags={"AccLevel"}, description="acc level")
public class AccApiV2LevelController {
    private static final Logger log = LoggerFactory.getLogger(AccApiV2LevelController.class);
    @Autowired
    private AccLevelService accLevelService;

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get AccLevel List", notes="Return AccLevel List", response=ApiResultMessage.class)
    public ApiResultMessage list(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage rs = new ApiResultMessage();
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.failedMessage((int)-90);
        }
        ArrayList apiAccLevels = Lists.newArrayList();
        Pager pager = this.accLevelService.getItemsByPage((BaseItem)new AccLevelItem(), pageNo - 1, pageSize.intValue());
        List accLevelItemList = pager.getData();
        if (!accLevelItemList.isEmpty()) {
            accLevelItemList.forEach(accLevelItem -> {
                AccApiLevelItem accApiLevelItem = AccApiLevelItem.createApiLevel((AccLevelItem)accLevelItem);
                if (accApiLevelItem != null) {
                    apiAccLevels.add(accApiLevelItem);
                }
            });
        }
        pager.setData((List)apiAccLevels);
        rs.setData((Object)pager);
        return rs;
    }
}

