/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.api.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.acc.api.vo.AccApiDeviceItem;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceItem;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/v2/device"})
@Api(tags={"AccDevice"}, description="acc device")
public class AccApiV2DeviceController {
    private static final Logger log = LoggerFactory.getLogger(AccApiV2DeviceController.class);
    @Autowired
    private AccDeviceService accDeviceService;

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Acc Devices", notes="Return Acc Device List", response=ApiResultMessage.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="Page Index", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="One Page Size", required=true, dataType="int", paramType="query")})
    public ApiResultMessage list(@RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) Integer pageSize) {
        ArrayList accApiDeviceItemList = Lists.newArrayList();
        if (pageNo == null || pageSize == null) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"acc_api_parameterValueCannotBeNull", (Object[])new Object[0]));
        }
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-91, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        Pager pager = this.accDeviceService.getItemsByPage((BaseItem)new AccDeviceItem(), pageNo - 1, pageSize.intValue());
        List accDeviceItemList = pager.getData();
        if (!accDeviceItemList.isEmpty()) {
            accDeviceItemList.forEach(accDeviceItem -> {
                boolean bl = accApiDeviceItemList.add(AccApiDeviceItem.createAccDevice((AccDeviceItem)accDeviceItem));
            });
        }
        pager.setData((List)accApiDeviceItemList);
        return ApiResultMessage.successMessage((Object)pager);
    }
}

