/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.api.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.acc.api.vo.AccApiReaderItem;
import com.zkteco.zkbiosecurity.acc.service.AccReaderService;
import com.zkteco.zkbiosecurity.acc.vo.AccReaderItem;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/reader"})
@Api(tags={"AccReader"}, description="acc reader")
public class AccApiReaderController {
    @Autowired
    private AccReaderService accReaderService;

    @ApiOperation(value="Get Acc Reader Info By Id", notes="Return Acc Reader Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/getAcc"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getReaderById(@RequestParam(name="id", required=false) String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return ApiResultMessage.message((int)-44, (String)I18nUtil.i18nCode((String)"acc_api_readerIdCannotBeNull", (Object[])new Object[0]));
        }
        AccReaderItem accReaderItem = this.accReaderService.getItemById(id);
        if (accReaderItem == null) {
            return ApiResultMessage.message((int)-44, (String)I18nUtil.i18nCode((String)"acc_api_theReaderDoesNotExist", (Object[])new Object[0]));
        }
        AccApiReaderItem accApiReaderItem = AccApiReaderItem.createApiReader((AccReaderItem)accReaderItem);
        return ApiResultMessage.successMessage((Object)accApiReaderItem);
    }

    @ResponseBody
    @RequestMapping(value={"/accList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Acc Readers", notes="Return Acc Reader List", response=ApiResultMessage.class)
    public ApiResultMessage list(@RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) Integer pageSize) {
        if (pageNo == null || pageSize == null) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"acc_api_parameterValueCannotBeNull", (Object[])new Object[0]));
        }
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        ArrayList accApiReaderItemList = Lists.newArrayList();
        List accReaderItemList = this.accReaderService.getItemsByPage((BaseItem)new AccReaderItem(), pageNo - 1, pageSize.intValue()).getData();
        if (!accReaderItemList.isEmpty()) {
            accReaderItemList.forEach(accReaderItem -> {
                AccApiReaderItem accApiReaderItem = AccApiReaderItem.createApiReader((AccReaderItem)accReaderItem);
                if (accApiReaderItem != null) {
                    accApiReaderItemList.add(accApiReaderItem);
                }
            });
        }
        return ApiResultMessage.successMessage((Object)accApiReaderItemList);
    }
}

