/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.api.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.acc.api.vo.AccApiDoorItem;
import com.zkteco.zkbiosecurity.acc.api.vo.AccApiDoorStateItem;
import com.zkteco.zkbiosecurity.acc.service.AccBaseDictionaryService;
import com.zkteco.zkbiosecurity.acc.service.AccCloudService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccRTMonitorService;
import com.zkteco.zkbiosecurity.acc.utils.AccEnumUtil;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDoorItem;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/door"})
@Api(tags={"AccDoor"}, description="acc door")
public class AccApiDoorController {
    private static final Logger log = LoggerFactory.getLogger(AccApiDoorController.class);
    @Autowired
    private AccDoorService accDoorService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccRTMonitorService accRTMonitorService;
    @Autowired
    private AccBaseDictionaryService accBaseDictionaryService;
    @Autowired
    private AccCloudService accCloudService;

    @ApiOperation(value="Get Door By Id", notes="Return Door Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/get"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getDoorById(@RequestParam(name="id", required=false) String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return ApiResultMessage.message((int)-44, (String)I18nUtil.i18nCode((String)"acc_api_doorIdNotNull", (Object[])new Object[0]));
        }
        ApiResultMessage rs = ApiResultMessage.successMessage();
        AccDoorItem accDoorItem = this.accDoorService.getItemById(id);
        if (accDoorItem != null) {
            rs.setData((Object)AccApiDoorItem.createApiDoor((AccDoorItem)accDoorItem));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Door List", notes="Return Door List", response=ApiResultMessage.class)
    public ApiResultMessage list(@RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) Integer pageSize) {
        if (pageNo == null || pageSize == null) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"acc_api_parameterValueCannotBeNull", (Object[])new Object[0]));
        }
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-91, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        ArrayList apiDoorItemList = Lists.newArrayList();
        List accDoorItemList = this.accDoorService.getItemsByPage((BaseItem)new AccDoorItem(), pageNo - 1, pageSize.intValue()).getData();
        if (!accDoorItemList.isEmpty()) {
            accDoorItemList.forEach(accDoorItem -> {
                AccApiDoorItem accApiDoorItem = AccApiDoorItem.createApiDoor((AccDoorItem)accDoorItem);
                if (accApiDoorItem != null) {
                    apiDoorItemList.add(accApiDoorItem);
                }
            });
        }
        return ApiResultMessage.successMessage((Object)apiDoorItemList);
    }

    @ResponseBody
    @RequestMapping(value={"/remoteOpenById"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Remote Open By Id", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage remoteOpenById(@RequestParam(name="doorId", required=false) String doorId, @RequestParam(name="interval", required=false) Integer interval) {
        if (StringUtils.isBlank((CharSequence)doorId)) {
            return ApiResultMessage.message((int)-44, (String)I18nUtil.i18nCode((String)"acc_api_doorIdNotNull", (Object[])new Object[0]));
        }
        if (interval == null) {
            return ApiResultMessage.message((int)-45, (String)I18nUtil.i18nCode((String)"acc_api_openingTimeCannotBeNull", (Object[])new Object[0]));
        }
        if (1 > interval || interval > 254) {
            return ApiResultMessage.message((int)-45, (String)I18nUtil.i18nCode((String)"acc_api_doorIntervalSize", (Object[])new Object[0]));
        }
        Map dataMap = this.accRTMonitorService.operateDoor("openDoor", interval == null || interval < 5 ? "5" : interval.toString(), doorId);
        if (dataMap == null) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return this.dealResultData(dataMap);
    }

    @ResponseBody
    @RequestMapping(value={"/remoteOpenByName"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Remote Open By Name", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage remoteOpenByName(@RequestParam(name="doorName", required=false) String doorName, @RequestParam(name="interval", required=false) Integer interval) {
        if (StringUtils.isBlank((CharSequence)doorName)) {
            return ApiResultMessage.message((int)-46, (String)I18nUtil.i18nCode((String)"acc_api_doorNameNotNull", (Object[])new Object[0]));
        }
        if (interval == null) {
            return ApiResultMessage.message((int)-45, (String)I18nUtil.i18nCode((String)"acc_api_openingTimeCannotBeNull", (Object[])new Object[0]));
        }
        if (1 > interval || interval > 254) {
            return ApiResultMessage.message((int)-45, (String)I18nUtil.i18nCode((String)"acc_api_doorIntervalSize", (Object[])new Object[0]));
        }
        AccDoorItem accDoorItem = this.accDoorService.getItemByName(doorName);
        if (accDoorItem == null) {
            return ApiResultMessage.message((int)-47, (String)I18nUtil.i18nCode((String)"acc_api_doorNotExist", (Object[])new Object[0]));
        }
        Map dataMap = this.accRTMonitorService.operateDoor("openDoor", interval == null || interval < 5 ? "5" : interval.toString(), accDoorItem.getId());
        if (dataMap == null) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return this.dealResultData(dataMap);
    }

    @ResponseBody
    @RequestMapping(value={"/remoteCloseById"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Remote Close By Id", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage remoteCloseById(@RequestParam(name="doorId", required=false) String doorId) {
        if (StringUtils.isBlank((CharSequence)doorId)) {
            return ApiResultMessage.message((int)-44, (String)I18nUtil.i18nCode((String)"acc_api_doorIdNotNull", (Object[])new Object[0]));
        }
        Map dataMap = this.accRTMonitorService.operateDoor("closeDoor", null, doorId);
        if (dataMap == null) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return this.dealResultData(dataMap);
    }

    @ResponseBody
    @RequestMapping(value={"/remoteCloseByName"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Remote Close By Name", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage remoteCloseByName(@RequestParam(name="doorName", required=false) String doorName) {
        if (StringUtils.isBlank((CharSequence)doorName)) {
            return ApiResultMessage.message((int)-46, (String)I18nUtil.i18nCode((String)"acc_api_doorNameNotNull", (Object[])new Object[0]));
        }
        AccDoorItem accDoorItem = this.accDoorService.getItemByName(doorName);
        Map dataMap = this.accRTMonitorService.operateDoor("closeDoor", null, accDoorItem.getId());
        if (dataMap == null) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return this.dealResultData(dataMap);
    }

    @ResponseBody
    @RequestMapping(value={"/allDoorState"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Doors State", notes="Return Doors State", response=ApiResultMessage.class)
    public ApiResultMessage getAllDoorState() {
        List accDeviceItemList = this.accDeviceService.getByCondition(new AccDeviceItem());
        HashMap devMap = Maps.newHashMap();
        if (!accDeviceItemList.isEmpty()) {
            accDeviceItemList.forEach(accDeviceItem -> {
                AccDeviceItem accDeviceItem2 = devMap.put(accDeviceItem.getSn(), accDeviceItem);
            });
        }
        ArrayList apiDoorStateItemList = Lists.newArrayList();
        JSONObject devState = (JSONObject)this.accRTMonitorService.getDevStateData(null).getData();
        JSONArray stateArray = devState.getJSONArray("doorState");
        if (Objects.nonNull(stateArray) && stateArray.size() > 0) {
            int i = 0;
            while (i < stateArray.size()) {
                JSONObject door = stateArray.getJSONObject(i);
                AccApiDoorStateItem apiDoorStateItem = this.buildApiDoorState(door);
                AccDeviceItem accDeviceItem2 = (AccDeviceItem)devMap.get(door.getString("devSn"));
                if (accDeviceItem2 != null) {
                    apiDoorStateItem.setDeviceId(accDeviceItem2.getId());
                }
                apiDoorStateItemList.add(apiDoorStateItem);
                ++i;
            }
        }
        return ApiResultMessage.successMessage((Object)apiDoorStateItemList);
    }

    @ResponseBody
    @RequestMapping(value={"/doorStateBySn"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Door State By Sn", notes="Return Door State", response=ApiResultMessage.class)
    public ApiResultMessage doorStateBySn(@RequestParam(name="deviceSn", required=false) String deviceSn) {
        if (StringUtils.isBlank((CharSequence)deviceSn)) {
            return ApiResultMessage.message((int)-48, (String)I18nUtil.i18nCode((String)"acc_api_devSnNotNull", (Object[])new Object[0]));
        }
        ApiResultMessage rs = this.accRTMonitorService.getDoorStateBySn(deviceSn);
        ArrayList apiDoorStateItemList = Lists.newArrayList();
        if (rs.getData() != null) {
            AccDeviceItem accDeviceItem = this.accDeviceService.getItemByDevSn(deviceSn);
            JSONArray doorState = (JSONArray)rs.getData();
            int i = 0;
            while (i < doorState.size()) {
                JSONObject door = doorState.getJSONObject(i);
                AccApiDoorStateItem apiDoorStateItem = this.buildApiDoorState(door);
                apiDoorStateItem.setDeviceId(accDeviceItem.getId());
                apiDoorStateItemList.add(apiDoorStateItem);
                ++i;
            }
        } else {
            return ApiResultMessage.message((int)-102, (String)I18nUtil.i18nCode((String)"acc_api_deviceNumberDoesNotExist", (Object[])new Object[0]));
        }
        return ApiResultMessage.successMessage((Object)apiDoorStateItemList);
    }

    @ResponseBody
    @RequestMapping(value={"/doorStateById"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Door State By Id", notes="Return Door State", response=ApiResultMessage.class)
    public ApiResultMessage doorStateById(@RequestParam(name="doorId", required=false) String doorId) {
        if (StringUtils.isBlank((CharSequence)doorId)) {
            return ApiResultMessage.message((int)-44, (String)I18nUtil.i18nCode((String)"acc_api_doorIdNotNull", (Object[])new Object[0]));
        }
        JSONArray doorState = (JSONArray)this.accRTMonitorService.getDoorState(doorId).getData();
        ArrayList apiDoorStateItemList = Lists.newArrayList();
        if (Objects.nonNull(doorState) && doorState.size() > 0) {
            AccDoorItem accDoorItem = this.accDoorService.getItemById(doorId);
            int i = 0;
            while (i < doorState.size()) {
                JSONObject door = doorState.getJSONObject(i);
                AccApiDoorStateItem apiDoorStateItem = this.buildApiDoorState(door);
                apiDoorStateItem.setDeviceId(accDoorItem.getDeviceId());
                apiDoorStateItemList.add(apiDoorStateItem);
                ++i;
            }
        } else {
            return ApiResultMessage.message((int)-47, (String)I18nUtil.i18nCode((String)"acc_api_doorNotExist", (Object[])new Object[0]));
        }
        return ApiResultMessage.successMessage((Object)apiDoorStateItemList);
    }

    private ApiResultMessage dealResultData(Map<String, String> dataMap) {
        String cmdIdData = dataMap.get("cmdId");
        if ("true".equals(dataMap.get("notExistDev"))) {
            return ApiResultMessage.message((int)-102, (String)I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)dataMap.get("offline"))) {
            return ApiResultMessage.message((int)-103, (String)I18nUtil.i18nCode((String)"acc_api_devOffline", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)dataMap.get("notSupport"))) {
            return ApiResultMessage.message((int)-104, (String)I18nUtil.i18nCode((String)"acc_dev_devNotSupportFunction", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)dataMap.get("faile"))) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)cmdIdData)) {
            String[] stringArray = cmdIdData.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cmdData = stringArray[n2];
                String cmdId = cmdData.split("=")[0];
                Map resultMap = this.accDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (Objects.isNull(resultMap) || Objects.isNull(Integer.valueOf((String)resultMap.get("result"))) || Integer.parseInt((String)resultMap.get("result")) < 0) {
                    return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
                }
                ++n2;
            }
        }
        return ApiResultMessage.successMessage();
    }

    private AccApiDoorStateItem buildApiDoorState(JSONObject door) {
        AccApiDoorStateItem apiDoorStateItem = new AccApiDoorStateItem();
        int connect = door.getIntValue("connect");
        String sensor = door.getString("sensor");
        String relay = door.getString("relay");
        int alarmLevel = door.getIntValue("alarmLevel");
        int alarm = AccEnumUtil.Alarm.getAlarmType(alarmLevel, door.getIntValue("alarm"));
        apiDoorStateItem.setId(door.getString("id"));
        apiDoorStateItem.setName(door.getString("name"));
        apiDoorStateItem.setAlarm(String.valueOf(alarm));
        apiDoorStateItem.setSensor(sensor);
        apiDoorStateItem.setRelay(relay);
        apiDoorStateItem.setConnect(String.valueOf(connect));
        return apiDoorStateItem;
    }
}

