/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="PATROL_POINT t LEFT JOIN PATROL_DEVICE pd ON t.PATROL_DEVICE_ID = pd.ID LEFT JOIN AUTH_AREA a ON a.id = pd.auth_area_id ")
@OrderBy(after="t.CREATE_TIME ASC")
@GridConfig(operate=true, idField="id", winHeight=350, winWidth=450, operates={@GridOperate(type="edit", permission="patrol:point:edit", url="patrolPoint.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="patrol:point:del", url="patrolPoint.do?del", label="common_op_del")})
public class PatrolPointItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40")
    private String id;
    @Column(name="t.PATROL_DEVICE_ID")
    private String devId;
    @Column(name="t.NAME")
    @GridColumn(label="patrol_point_name", width="150", columnType="edit", editUrl="patrolPoint.do?edit")
    private String name;
    @Column(name="pd.AUTH_AREA_ID")
    private String authAreaId;
    @Condition(value="pd.AUTH_AREA_ID IN (%s)", equalTag="in")
    private String authAreaIdIn;
    @Column(name="a.NAME")
    @GridColumn(label="base_area_name", width="150", sort="na")
    private String authAreaName;
    @Column(name="t.PATROL_TAG")
    private String patrolTag;
    @Column(name="t.ACC_READER_ID")
    private String accReaderId;
    @Column(name="t.PATROL_TAG_NAME")
    @GridColumn(label="patrol_point_tagName", width="170")
    private String patrolTagName;
    @Column(name="pd.MODULE")
    @GridColumn(label="patrol_point_devModule", format="acc=patrol_point_accmodel", width="140")
    private String devModule;
    @Column(name="pd.DEVICE_ALIAS")
    private String deviceAlias;
    @Column(name="t.POSITION")
    @GridColumn(label="patrol_point_position", width="150")
    private String position;
    @Column(name="t.LEVEL_ID")
    @GridColumn(show=false)
    private String levelId;
    @Column(name="t.LEVEL_NAME")
    @GridColumn(show=false)
    private String levelName;
    private String deviceSn;
    @Condition(value="a.ID IN (SELECT ua.AUTH_AREA_ID FROM AUTH_USER_AREA ua WHERE ua.AUTH_USER_ID=''{0}'')")
    private String userId;

    public PatrolPointItem() {
    }

    public PatrolPointItem(Boolean equals) {
        super(equals);
    }

    public PatrolPointItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PatrolPointItem(String id, String devId) {
        this.id = id;
        this.devId = devId;
    }

    public PatrolPointItem(String id, String name, String patrolTag, String patrolTagName, String position, String levelId, String levelName) {
        this.id = id;
        this.name = name;
        this.patrolTag = patrolTag;
        this.patrolTagName = patrolTagName;
        this.position = position;
        this.levelId = levelId;
        this.levelName = levelName;
    }

    public String getId() {
        return this.id;
    }

    public String getDevId() {
        return this.devId;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthAreaId() {
        return this.authAreaId;
    }

    public String getAuthAreaIdIn() {
        return this.authAreaIdIn;
    }

    public String getAuthAreaName() {
        return this.authAreaName;
    }

    public String getPatrolTag() {
        return this.patrolTag;
    }

    public String getAccReaderId() {
        return this.accReaderId;
    }

    public String getPatrolTagName() {
        return this.patrolTagName;
    }

    public String getDevModule() {
        return this.devModule;
    }

    public String getDeviceAlias() {
        return this.deviceAlias;
    }

    public String getPosition() {
        return this.position;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getUserId() {
        return this.userId;
    }

    public PatrolPointItem setId(String id) {
        this.id = id;
        return this;
    }

    public PatrolPointItem setDevId(String devId) {
        this.devId = devId;
        return this;
    }

    public PatrolPointItem setName(String name) {
        this.name = name;
        return this;
    }

    public PatrolPointItem setAuthAreaId(String authAreaId) {
        this.authAreaId = authAreaId;
        return this;
    }

    public PatrolPointItem setAuthAreaIdIn(String authAreaIdIn) {
        this.authAreaIdIn = authAreaIdIn;
        return this;
    }

    public PatrolPointItem setAuthAreaName(String authAreaName) {
        this.authAreaName = authAreaName;
        return this;
    }

    public PatrolPointItem setPatrolTag(String patrolTag) {
        this.patrolTag = patrolTag;
        return this;
    }

    public PatrolPointItem setAccReaderId(String accReaderId) {
        this.accReaderId = accReaderId;
        return this;
    }

    public PatrolPointItem setPatrolTagName(String patrolTagName) {
        this.patrolTagName = patrolTagName;
        return this;
    }

    public PatrolPointItem setDevModule(String devModule) {
        this.devModule = devModule;
        return this;
    }

    public PatrolPointItem setDeviceAlias(String deviceAlias) {
        this.deviceAlias = deviceAlias;
        return this;
    }

    public PatrolPointItem setPosition(String position) {
        this.position = position;
        return this;
    }

    public PatrolPointItem setLevelId(String levelId) {
        this.levelId = levelId;
        return this;
    }

    public PatrolPointItem setLevelName(String levelName) {
        this.levelName = levelName;
        return this;
    }

    public PatrolPointItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public PatrolPointItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String toString() {
        return "PatrolPointItem(id=" + this.getId() + ", devId=" + this.getDevId() + ", name=" + this.getName() + ", authAreaId=" + this.getAuthAreaId() + ", authAreaIdIn=" + this.getAuthAreaIdIn() + ", authAreaName=" + this.getAuthAreaName() + ", patrolTag=" + this.getPatrolTag() + ", accReaderId=" + this.getAccReaderId() + ", patrolTagName=" + this.getPatrolTagName() + ", devModule=" + this.getDevModule() + ", deviceAlias=" + this.getDeviceAlias() + ", position=" + this.getPosition() + ", levelId=" + this.getLevelId() + ", levelName=" + this.getLevelName() + ", deviceSn=" + this.getDeviceSn() + ", userId=" + this.getUserId() + ")";
    }
}

