/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="PERS_PERSON t LEFT join AUTH_DEPARTMENT d on t.auth_dept_id = d.id")
@OrderBy(after="t.UPDATE_TIME ASC")
@GridConfig(operate=false, idField="id")
public class PatrolPersonSelectItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @GridColumn(columnType="ra", width="40", sortNo=0, align="center")
    private String ra;
    private String persId;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", sortNo=1, width="70")
    private String persPin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", sortNo=2, width="65")
    private String persName;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="65")
    private String persLastName;
    private String cardNo;
    private String gender;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_entity", sortNo=6, width="*")
    private String deptName;
    private String type;
    @Condition(value="t.ID", equalTag="not in")
    private String selectId;
    private String linkId;
    private String modelType;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="t.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.ID NOT IN (SELECT pgp.PERS_PERSON_ID FROM PATROL_GROUP_PERSON pgp WHERE pgp.PATROL_GROUP_ID =''{0}'')")
    private String notInGroupId;
    @Column(name="t.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;

    public PatrolPersonSelectItem() {
    }

    public PatrolPersonSelectItem(Boolean equals) {
        super(equals);
    }

    public PatrolPersonSelectItem(String id) {
        this.id = id;
    }

    public PatrolPersonSelectItem(String id, String ra, String persId, String persPin, String persName, String persLastName, String cardNo, String gender, String deptName, String type, String selectId) {
        this.id = id;
        this.ra = ra;
        this.persId = persId;
        this.persPin = persPin;
        this.persName = persName;
        this.persLastName = persLastName;
        this.cardNo = cardNo;
        this.gender = gender;
        this.deptName = deptName;
        this.type = type;
        this.selectId = selectId;
    }

    public String getId() {
        return this.id;
    }

    public String getRa() {
        return this.ra;
    }

    public String getPersId() {
        return this.persId;
    }

    public String getPersPin() {
        return this.persPin;
    }

    public String getPersName() {
        return this.persName;
    }

    public String getPersLastName() {
        return this.persLastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getGender() {
        return this.gender;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getType() {
        return this.type;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getNotInGroupId() {
        return this.notInGroupId;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public PatrolPersonSelectItem setId(String id) {
        this.id = id;
        return this;
    }

    public PatrolPersonSelectItem setRa(String ra) {
        this.ra = ra;
        return this;
    }

    public PatrolPersonSelectItem setPersId(String persId) {
        this.persId = persId;
        return this;
    }

    public PatrolPersonSelectItem setPersPin(String persPin) {
        this.persPin = persPin;
        return this;
    }

    public PatrolPersonSelectItem setPersName(String persName) {
        this.persName = persName;
        return this;
    }

    public PatrolPersonSelectItem setPersLastName(String persLastName) {
        this.persLastName = persLastName;
        return this;
    }

    public PatrolPersonSelectItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public PatrolPersonSelectItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public PatrolPersonSelectItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PatrolPersonSelectItem setType(String type) {
        this.type = type;
        return this;
    }

    public PatrolPersonSelectItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public PatrolPersonSelectItem setLinkId(String linkId) {
        this.linkId = linkId;
        return this;
    }

    public PatrolPersonSelectItem setModelType(String modelType) {
        this.modelType = modelType;
        return this;
    }

    public PatrolPersonSelectItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PatrolPersonSelectItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PatrolPersonSelectItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PatrolPersonSelectItem setNotInGroupId(String notInGroupId) {
        this.notInGroupId = notInGroupId;
        return this;
    }

    public PatrolPersonSelectItem setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
        return this;
    }

    public String toString() {
        return "PatrolPersonSelectItem(id=" + this.getId() + ", ra=" + this.getRa() + ", persId=" + this.getPersId() + ", persPin=" + this.getPersPin() + ", persName=" + this.getPersName() + ", persLastName=" + this.getPersLastName() + ", cardNo=" + this.getCardNo() + ", gender=" + this.getGender() + ", deptName=" + this.getDeptName() + ", type=" + this.getType() + ", selectId=" + this.getSelectId() + ", linkId=" + this.getLinkId() + ", modelType=" + this.getModelType() + ", likeName=" + this.getLikeName() + ", userId=" + this.getUserId() + ", inDeptId=" + this.getInDeptId() + ", notInGroupId=" + this.getNotInGroupId() + ", enabledCredential=" + this.getEnabledCredential() + ")";
    }
}

