/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="PATROL_GROUP_PERSON t LEFT JOIN PATROL_GROUP pg ON pg.ID = t.PATROL_GROUP_ID LEFT JOIN PERS_PERSON pp ON t.PERS_PERSON_ID = pp.ID LEFT join AUTH_DEPARTMENT d on pp.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME ASC")
@GridConfig(operate=false, idField="id")
public class PatrolGroupPersonItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40")
    private String id;
    @Column(name="t.PATROL_GROUP_ID")
    private String patrolGroupId;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Column(name="pp.PIN")
    @GridColumn(label="pers_person_pin", width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String persPin;
    @Column(name="pp.NAME")
    @GridColumn(label="pers_person_name", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String persName;
    @Column(name="pp.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String persLastName;
    @Column(name="d.NAME")
    @GridColumn(label="base_department_deptName", width="150")
    private String deptName;
    @Column(name="t.PATROL_GROUP_ID", equalTag="=")
    private String linkId;
    private String modelType;
    private String patrolGroupName;
    @Condition(value="(LOWER (pp.NAME) LIKE LOWER (''%{0}%'') OR LOWER (pp.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="pp.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public PatrolGroupPersonItem() {
    }

    public PatrolGroupPersonItem(Boolean equals) {
        super(equals);
    }

    public PatrolGroupPersonItem(String id, String patrolGroupId, String personId, String persPin, String persName, String persLastName, String deptName) {
        this.id = id;
        this.patrolGroupId = patrolGroupId;
        this.personId = personId;
        this.persPin = persPin;
        this.persName = persName;
        this.persLastName = persLastName;
        this.deptName = deptName;
    }

    public PatrolGroupPersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public PatrolGroupPersonItem setPatrolGroupId(String patrolGroupId) {
        this.patrolGroupId = patrolGroupId;
        return this;
    }

    public PatrolGroupPersonItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PatrolGroupPersonItem setPersPin(String persPin) {
        this.persPin = persPin;
        return this;
    }

    public PatrolGroupPersonItem setPersName(String persName) {
        this.persName = persName;
        return this;
    }

    public PatrolGroupPersonItem setPersLastName(String persLastName) {
        this.persLastName = persLastName;
        return this;
    }

    public PatrolGroupPersonItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PatrolGroupPersonItem setLinkId(String linkId) {
        this.linkId = linkId;
        return this;
    }

    public PatrolGroupPersonItem setModelType(String modelType) {
        this.modelType = modelType;
        return this;
    }

    public PatrolGroupPersonItem setPatrolGroupName(String patrolGroupName) {
        this.patrolGroupName = patrolGroupName;
        return this;
    }

    public PatrolGroupPersonItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PatrolGroupPersonItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPatrolGroupId() {
        return this.patrolGroupId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersPin() {
        return this.persPin;
    }

    public String getPersName() {
        return this.persName;
    }

    public String getPersLastName() {
        return this.persLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getPatrolGroupName() {
        return this.patrolGroupName;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String toString() {
        return "PatrolGroupPersonItem(id=" + this.getId() + ", patrolGroupId=" + this.getPatrolGroupId() + ", personId=" + this.getPersonId() + ", persPin=" + this.getPersPin() + ", persName=" + this.getPersName() + ", persLastName=" + this.getPersLastName() + ", deptName=" + this.getDeptName() + ", linkId=" + this.getLinkId() + ", modelType=" + this.getModelType() + ", patrolGroupName=" + this.getPatrolGroupName() + ", likeName=" + this.getLikeName() + ", userId=" + this.getUserId() + ")";
    }
}

