/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.init;

import com.zkteco.zkbiosecurity.auth.service.AuthAreaService;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthAreaItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import com.zkteco.zkbiosecurity.vdb.service.VdbBuildingService;
import com.zkteco.zkbiosecurity.vdb.service.VdbUnitService;
import com.zkteco.zkbiosecurity.vdb.vo.VdbBuildingItem;
import com.zkteco.zkbiosecurity.vdb.vo.VdbUnitItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=180)
public class VdbInit
implements CommandLineRunner {
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private VdbBuildingService vdbBuildingService;
    @Autowired
    private AuthAreaService authAreaService;
    @Autowired
    private VdbUnitService vdbUnitService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("VdbInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initUpgradeVersion();
            this.initVdbBuilding();
            this.initVdbUnit();
            this.baseSysParamService.setAlreadyInitModule("VdbInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = null;
        AuthPermissionItem topMenuItem = null;
        AuthPermissionItem subMenuItem = null;
        AuthPermissionItem subButtonItem = null;
        systemItem = new AuthPermissionItem("Vdb", "vdb_module", "vdb", "system", "true", Integer.valueOf(18));
        systemItem = this.authPermissionService.initData(systemItem);
        topMenuItem = new AuthPermissionItem("VdbBasicManagement", "base_leftMenu_basicManagement", "vdb:basic:management", "menu", "true", Integer.valueOf(1));
        topMenuItem.setParentId(systemItem.getId());
        topMenuItem.setImg("vdb_basic.png");
        topMenuItem.setImgHover("vdb_basic_over.png");
        topMenuItem = this.authPermissionService.initData(topMenuItem);
        subMenuItem = new AuthPermissionItem("VdbBuilding", "vdb_leftMenu_building", "vdb:building", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("vdbBuilding.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VdbBuildingRefresh", "common_op_refresh", "vdb:building:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbBuildingAdd", "common_op_new", "vdb:building:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbBuildingEdit", "common_op_edit", "vdb:building:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbBuildingDel", "common_op_del", "vdb:building:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbBuildingExport", "common_op_export", "vdb:building:export", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbBuildingImport", "common_op_import", "vdb:building:import", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VdbUnit", "vdb_leftMenu_unit", "vdb:unit", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("vdbUnit.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VdbUnitRefresh", "common_op_refresh", "vdb:unit:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbUnitAdd", "common_op_new", "vdb:unit:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbUnitEdit", "common_op_edit", "vdb:unit:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbUnitDel", "common_op_del", "vdb:unit:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbUnitExport", "common_op_export", "vdb:unit:export", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbUnitImport", "common_op_import", "vdb:unit:import", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        topMenuItem = new AuthPermissionItem("VdbDeviceManagement", "vdb_leftMenu_deviceManagement", "vdb:device:management", "menu", "true", Integer.valueOf(2));
        topMenuItem.setParentId(systemItem.getId());
        topMenuItem.setImg("vdb_device.png");
        topMenuItem.setImgHover("vdb_device_over.png");
        topMenuItem = this.authPermissionService.initData(topMenuItem);
        subMenuItem = new AuthPermissionItem("VdbDevice", "vdb_leftMenu_device", "vdb:device", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("vdbDevice.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VdbDeviceRefresh", "common_op_refresh", "vdb:device:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbDeviceAdd", "common_op_new", "vdb:device:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbDeviceEdit", "common_op_edit", "vdb:device:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbDeviceDel", "common_op_del", "vdb:device:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbDeviceExport", "common_op_export", "vdb:device:export", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbDeviceImport", "common_op_import", "vdb:device:import", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbDeviceSyncTime", "common_dev_syncTime", "vdb:device:syncTime", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbDeviceSyncPersonData", "vdb_device_syncPerson", "vdb:device:syncPersonData", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbDeviceUploadRecords", "common_devOpType_downAlllog", "vdb:device:uploadRecords", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        topMenuItem = new AuthPermissionItem("VdbLevelManagement", "vdb_leftMenu_levelManagement", "vdb:level:management", "menu", "true", Integer.valueOf(3));
        topMenuItem.setParentId(systemItem.getId());
        topMenuItem.setImg("vdb_level.png");
        topMenuItem.setImgHover("vdb_level_over.png");
        topMenuItem = this.authPermissionService.initData(topMenuItem);
        subMenuItem = new AuthPermissionItem("VdbLevel", "vdb_leftMenu_accessLevel", "vdb:level", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("vdbLevel.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VdbLevelRefresh", "common_op_refresh", "vdb:level:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbLevelAdd", "common_op_new", "vdb:level:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbLevelEdit", "common_op_edit", "vdb:level:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbLevelDel", "common_op_del", "vdb:level:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbLevelAddDevice", "vdb_level_addDevice", "vdb:level:addDevice", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbLevelDelDevice", "vdb_level_delDevice", "vdb:level:delDevice", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbLevelExport", "vdb_level_exportLevel", "vdb:level:export", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbLevelDeviceExport", "vdb_level_exportLevelDevice", "vdb:levelDevice:export", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbLevelImport", "vdb_level_importLevel", "vdb:level:import", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbLevelDeviceImport", "vdb_level_importLevelDevice", "vdb:levelDevice:import", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VdbPersonLevelByLevel", "common_leftMenu_levelSetByLevel", "vdb:personLevelByLevel", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("vdbPersonLevelByLevel.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VdbPersonLevelByLevelRefresh", "common_op_refresh", "vdb:personLevelByLevel:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbPersonLevelByLevelAddPerson", "pers_common_addPerson", "vdb:personLevelByLevel:addPerson", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbPersonLevelByLevelDelPerson", "pers_common_delPerson", "vdb:personLevelByLevel:delPerson", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbPersonLevelByLevelExport", "vdb_level_exportLevelPerson", "vdb:personLevelByLevel:export", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbPersonLevelByLevelImport", "vdb_level_importLevelPerson", "vdb:personLevelByLevel:import", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VdbPersonLevelByPerson", "common_leftMenu_levelSetByPerson", "vdb:personLevelByPerson", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("vdbPersonLevelByPerson.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VdbPersonLevelByPersonRefresh", "common_op_refresh", "vdb:personLevelByPerson:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbPersonLevelByPersonAddLevel", "common_level_addPersonLevel", "vdb:personLevelByPerson:addLevel", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbPersonLevelByPersonDelLevel", "common_level_delPersonLevel", "vdb:personLevelByPerson:delLevel", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbPersonLevelByPersonExport", "common_op_export", "vdb:personLevelByPerson:export", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbPersonLevelByPersonSync", "vdb_personLevelByPerson_syncLevel", "vdb:personLevelByPerson:sync", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        topMenuItem = new AuthPermissionItem("VdbRecords", "vdb_leftMenu_records", "vdb:records:management", "menu", "true", Integer.valueOf(4));
        topMenuItem.setParentId(systemItem.getId());
        topMenuItem.setImg("comm_reports.png");
        topMenuItem.setImgHover("comm_reports_over.png");
        topMenuItem = this.authPermissionService.initData(topMenuItem);
        subMenuItem = new AuthPermissionItem("VdbCallRecords", "vdb_leftMenu_callRecords", "vdb:callRecords", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("vdbCallRecords.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VdbCallRecordsRefresh", "common_op_refresh", "vdb:callRecords:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbCallRecordsUpload", "vdb_records_upload", "vdb:callRecords:upload", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbCallRecordsExport", "common_op_export", "vdb:callRecords:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VdbUnlockRecords", "vdb_leftMenu_unlockRecords", "vdb:unlockRecords", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("vdbUnlockRecords.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VdbUnlockRecordsRefresh", "common_op_refresh", "vdb:unlockRecords:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbUnlockRecordsUpload", "vdb_records_upload", "vdb:unlockRecords:upload", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VdbUnlockRecordsExport", "common_op_export", "vdb:unlockRecords:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = this.authPermissionService.getItemByCode("PersPerson");
        if (null != subMenuItem) {
            subButtonItem = new AuthPermissionItem("PersPersonVdbEdit", "pers_person_vdbSet", "pers:person:vdbEdit", "button", "true", Integer.valueOf(107));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"vdb");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("VdbUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("VdbUpgradeVersion", curVersion, "Vdb Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }

    private void initVdbBuilding() {
        AuthAreaItem authAreaItem = this.authAreaService.getItemByCode("1");
        VdbBuildingItem vdbBuildingItem = new VdbBuildingItem(I18nUtil.i18nCode((String)"vdb_building_initName", (Object[])new Object[0]), "1", authAreaItem.getId(), Boolean.valueOf(true));
        this.vdbBuildingService.initData(vdbBuildingItem);
    }

    private void initVdbUnit() {
        VdbBuildingItem vdbBuildingItem = this.vdbBuildingService.getInitData();
        if (vdbBuildingItem != null) {
            VdbUnitItem vdbUnitItem = new VdbUnitItem(I18nUtil.i18nCode((String)"vdb_unit_initName", (Object[])new Object[0]), "1", Boolean.valueOf(true), vdbBuildingItem.getId());
            this.vdbUnitService.initData(vdbUnitItem);
        }
    }
}

