/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.redis.redisson.queue;

import java.util.concurrent.TimeUnit;
import org.redisson.api.RBlockingDeque;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisDelayQueueUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisDelayQueueUtil.class);
    @Autowired
    private RedissonClient redissonClient;

    public <T> void addDelayQueue(T value, long delay, TimeUnit timeUnit, String queueCode) {
        try {
            RBlockingDeque blockingDeque = this.redissonClient.getBlockingDeque(queueCode);
            RDelayedQueue delayedQueue = this.redissonClient.getDelayedQueue((RQueue)blockingDeque);
            delayedQueue.offer(value, delay, timeUnit);
            log.info("(\u6dfb\u52a0\u5ef6\u65f6\u961f\u5217\u6210\u529f) \u961f\u5217\u952e\uff1a{}\uff0c\u961f\u5217\u503c\uff1a{}\uff0c\u5ef6\u8fdf\u65f6\u95f4\uff1a{}", new Object[]{queueCode, value, String.valueOf(timeUnit.toSeconds(delay)) + "\u79d2"});
        }
        catch (Exception e) {
            log.error("(\u6dfb\u52a0\u5ef6\u65f6\u961f\u5217\u5931\u8d25) {}", (Object)e.getMessage());
            throw new RuntimeException("(\u6dfb\u52a0\u5ef6\u65f6\u961f\u5217\u5931\u8d25)");
        }
    }

    public <T> T getDelayQueue(String queueCode) throws InterruptedException {
        RBlockingDeque blockingDeque = this.redissonClient.getBlockingDeque(queueCode);
        Object value = blockingDeque.take();
        return (T)value;
    }
}

