/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.redis.redisson.config;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.redis.redisson.config.RedissonConfigProperties;
import java.io.IOException;
import java.util.ArrayList;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonConfig {
    private static final Logger log = LoggerFactory.getLogger(RedissonConfig.class);
    private static final String REDIS_PROTsOCOL_PREFIX = "redis://";
    private static final String REDISS_PROTOCOL_PREFIX = "rediss://";
    @Autowired
    private RedissonConfigProperties redissonConfigProperties;
    @Autowired
    private RedisProperties redisProperties;

    @Bean
    public RedissonClient getRedisson() {
        Config config = null;
        RedisModeEnum redisMode = this.getRedisMode();
        if (redisMode.equals((Object)RedisModeEnum.CLUSTER)) {
            config = this.dealConfig(RedisModeEnum.CLUSTER);
            ArrayList<String> clusterNodes = new ArrayList<String>();
            for (String node : this.redisProperties.getCluster().getNodes()) {
                clusterNodes.add(String.valueOf(this.getRedisProtocol()) + node);
            }
            config.useClusterServers().addNodeAddress(clusterNodes.toArray(new String[clusterNodes.size()])).setPassword(this.redisProperties.getPassword());
        } else if (redisMode.equals((Object)RedisModeEnum.SENTINEL)) {
            config = this.dealConfig(RedisModeEnum.SENTINEL);
            ArrayList<String> sentinelNodes = new ArrayList<String>();
            for (String node : this.redisProperties.getSentinel().getNodes()) {
                sentinelNodes.add(String.valueOf(this.getRedisProtocol()) + node);
            }
            config.useSentinelServers().setMasterName(this.redisProperties.getSentinel().getMaster()).addSentinelAddress(sentinelNodes.toArray(new String[sentinelNodes.size()])).setDatabase(this.redisProperties.getDatabase()).setPassword(this.redisProperties.getPassword());
        } else {
            config = this.dealConfig(RedisModeEnum.SINGLE);
            ((SingleServerConfig)config.useSingleServer().setAddress(String.valueOf(this.getRedisProtocol()) + this.redisProperties.getHost() + ":" + this.redisProperties.getPort()).setPassword(this.redisProperties.getPassword())).setDatabase(this.redisProperties.getDatabase());
        }
        return Redisson.create((Config)config);
    }

    private Config dealConfig(RedisModeEnum redisMode) {
        Config config = new Config();
        if (redisMode.equals((Object)RedisModeEnum.CLUSTER)) {
            if (this.redissonConfigProperties.getCluster() != null) {
                String cluster = JSONObject.toJSONString((Object)this.redissonConfigProperties.getCluster());
                JSONObject clusterObj = JSONObject.parseObject((String)cluster);
                clusterObj.remove((Object)"natMapper");
                clusterObj.remove((Object)"loadBalancer");
                JSONObject cluster2 = new JSONObject();
                cluster2.put("clusterServersConfig", (Object)clusterObj);
                config = RedissonConfig.fromJSON(JSONObject.toJSONString((Object)cluster2));
            }
        } else if (redisMode.equals((Object)RedisModeEnum.SENTINEL)) {
            if (this.redissonConfigProperties.getSentinel() != null) {
                String sentinel = JSONObject.toJSONString((Object)this.redissonConfigProperties.getSentinel());
                JSONObject sentinelObj = JSONObject.parseObject((String)sentinel);
                sentinelObj.remove((Object)"natMapper");
                sentinelObj.remove((Object)"loadBalancer");
                JSONObject sentinel2 = new JSONObject();
                sentinel2.put("sentinelServersConfig", (Object)sentinelObj);
                config = RedissonConfig.fromJSON(JSONObject.toJSONString((Object)sentinel2));
            }
        } else {
            config = RedissonConfig.fromJSON(JSONObject.toJSONString((Object)this.redissonConfigProperties));
        }
        return config;
    }

    private static Config fromJSON(String content) {
        try {
            ConfigSupport support = new ConfigSupport();
            return (Config)support.fromJSON(content, Config.class);
        }
        catch (IOException e) {
            log.error("redisson config error exception: ", (Throwable)e);
            return new Config();
        }
    }

    private String getRedisProtocol() {
        String prefix = REDIS_PROTsOCOL_PREFIX;
        if (this.redisProperties.isSsl()) {
            prefix = REDISS_PROTOCOL_PREFIX;
        }
        return prefix;
    }

    private RedisModeEnum getRedisMode() {
        if (this.redisProperties.getCluster() != null && this.redisProperties.getCluster().getNodes().size() > 0) {
            return RedisModeEnum.CLUSTER;
        }
        if (this.redisProperties.getSentinel() != null && this.redisProperties.getSentinel().getNodes().size() > 0) {
            return RedisModeEnum.SENTINEL;
        }
        return RedisModeEnum.SINGLE;
    }

    static enum RedisModeEnum {
        CLUSTER,
        SENTINEL,
        SINGLE;

    }
}

