/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.redis.redisson.aspect;

import com.zkteco.zkbiosecurity.redis.redisson.annotation.RedisLock;
import com.zkteco.zkbiosecurity.redis.redisson.util.SpelUtil;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RedisLockAspect {
    private static final Logger log = LoggerFactory.getLogger(RedisLockAspect.class);
    @Autowired
    private RedissonClient redissonClient;
    private static final String REDISSON_LOCK_PREFIX = "redisson_lock:";

    @Pointcut(value="@annotation(com.zkteco.zkbiosecurity.redis.redisson.annotation.RedisLock)")
    public void executeService() {
    }

    @Around(value="executeService() && @annotation(redisLock)")
    public Object around(ProceedingJoinPoint joinPoint, RedisLock redisLock) throws Throwable {
        Object result;
        String spel = redisLock.key();
        String lockName = redisLock.lockName();
        String redisKey = this.getRedisKey(joinPoint, lockName, spel);
        RLock rLock = this.redissonClient.getLock(redisKey);
        boolean lockSuccess = false;
        try {
            lockSuccess = rLock.tryLock((long)redisLock.waitTime(), (long)redisLock.expire(), redisLock.timeUnit());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (!lockSuccess) {
            log.error("\u83b7\u53d6redisson\u9501" + redisKey + "\u5931\u8d25\uff0c\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            throw new Exception("\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        try {
            result = joinPoint.proceed();
        }
        finally {
            rLock.unlock();
        }
        return result;
    }

    private String getRedisKey(ProceedingJoinPoint joinPoint, String lockName, String spel) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        Object target = joinPoint.getTarget();
        Object[] arguments = joinPoint.getArgs();
        return REDISSON_LOCK_PREFIX + lockName + ":" + SpelUtil.parse(target, spel, targetMethod, arguments);
    }
}

