/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.redis.configuration;

import com.zkteco.zkbiosecurity.base.bean.CacheTime;
import com.zkteco.zkbiosecurity.base.trait.CacheExpireFunction;
import com.zkteco.zkbiosecurity.redis.configuration.FastJson2JsonRedisSerializer;
import com.zkteco.zkbiosecurity.redis.configuration.RedisPrefix;
import com.zkteco.zkbiosecurity.redis.constants.RedisConstant;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.CacheKeyPrefix;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
public class RedisTemplateConfiguration {
    private Map<String, RedisCacheConfiguration> ttlMap;
    @Autowired(required=false)
    private CacheExpireFunction[] cacheTtl;
    private List<String> flushCache = new ArrayList<String>();

    @Bean
    @Primary
    public RedisTemplate redisTemplate(LettuceConnectionFactory lettuceConnectionFactory) throws UnknownHostException {
        RedisTemplate redisTemplate = new RedisTemplate();
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        FastJson2JsonRedisSerializer<Object> fastJson2JsonRedisSerializer = new FastJson2JsonRedisSerializer<Object>(Object.class);
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setValueSerializer(fastJson2JsonRedisSerializer);
        redisTemplate.setHashValueSerializer(fastJson2JsonRedisSerializer);
        redisTemplate.setConnectionFactory((RedisConnectionFactory)lettuceConnectionFactory);
        return redisTemplate;
    }

    @PostConstruct
    public void init() {
        if (this.cacheTtl != null) {
            this.ttlMap = new HashMap<String, RedisCacheConfiguration>();
            this.ttlMap = Stream.of(this.cacheTtl).map(CacheExpireFunction::addExpires).peek(cacheTime -> {
                if (cacheTime.getNeedFlush().booleanValue()) {
                    this.flushCache.add(cacheTime.getName());
                }
            }).collect(Collectors.toMap(CacheTime::getName, cacheTime -> this.createRedisCacheConfiguration(cacheTime.getName(), cacheTime.getExpire().getSeconds())));
        }
    }

    @Bean
    public KeyGenerator KeyGenerator() {
        return (target, method, params) -> {
            StringBuilder sb = new StringBuilder();
            sb.append(target.getClass().getName());
            sb.append(method.getName());
            Object[] objectArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                sb.append(obj.toString());
                ++n2;
            }
            return sb.toString();
        };
    }

    @Bean
    public CacheManager cacheManager(RedisConnectionFactory factory) {
        RedisCacheWriter redisCacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)factory);
        RedisCacheConfiguration defaultCacheConfig = this.createRedisCacheConfiguration("cache:", RedisConstant.DEFAULT_EXPIRATION);
        if (this.ttlMap != null) {
            return RedisCacheManager.builder((RedisCacheWriter)redisCacheWriter).cacheDefaults(defaultCacheConfig).initialCacheNames(this.ttlMap.keySet()).withInitialCacheConfigurations(this.ttlMap).build();
        }
        return RedisCacheManager.builder((RedisCacheWriter)redisCacheWriter).cacheDefaults(defaultCacheConfig).build();
    }

    private RedisCacheConfiguration createRedisCacheConfiguration(String delimiter, long entryTtl) {
        RedisPrefix cachePrefix = new RedisPrefix(delimiter);
        FastJson2JsonRedisSerializer<Object> fastJsonRedisSerializer = new FastJson2JsonRedisSerializer<Object>(Object.class);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        RedisSerializationContext.SerializationPair pair = RedisSerializationContext.SerializationPair.fromSerializer(fastJsonRedisSerializer);
        RedisCacheConfiguration defaultCacheConfig = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofSeconds(entryTtl)).computePrefixWith((CacheKeyPrefix)cachePrefix).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)stringRedisSerializer)).serializeValuesWith(pair);
        return defaultCacheConfig;
    }
}

