/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.redis.configuration;

import org.springframework.data.redis.cache.CacheKeyPrefix;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisPrefix
implements CacheKeyPrefix {
    private final RedisSerializer serializer = new StringRedisSerializer();
    private final String delimiter;

    public RedisPrefix() {
        this("cache:");
    }

    public RedisPrefix(String delimiter) {
        this.delimiter = delimiter;
    }

    public String compute(String cacheName) {
        String preKey = null;
        if (this.delimiter != null) {
            preKey = this.delimiter;
            if (!this.delimiter.endsWith(":")) {
                preKey = String.valueOf(this.delimiter) + ":";
            }
            preKey = preKey.concat(cacheName).concat(":");
        } else {
            preKey = cacheName.concat(":");
        }
        return preKey;
    }
}

