/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.redis.configuration;

import com.zkteco.zkbiosecurity.redis.configuration.KeyExpireMessageListener;
import com.zkteco.zkbiosecurity.redis.configuration.RedisClusterMessageListenerFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@ConditionalOnClass(value={LettuceConnection.class, RedisOperations.class, MessageListener.class})
@AutoConfigureAfter(value={RedisMessageListenerContainerConfig.class})
public class RedisMessageListenerContainerConfig {
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    @Autowired
    private KeyExpireMessageListener messageListener;
    @Value(value="spring.redis.topic")
    private String topic;
    @Value(value="${adms.push.port:9999}")
    private int port;
    @Value(value="${spring.redis.database:0}")
    private int redisDb;

    @Bean
    @ConditionalOnExpression(value="!'${spring.redis.host:}'.isEmpty()||!'${spring.redis.sentinel.nodes:}'.isEmpty()")
    public RedisMessageListenerContainer configRedisMessageListenerContainer() {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(this.redisTemplate.getConnectionFactory());
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(10);
        executor.setMaxPoolSize(100);
        executor.setQueueCapacity(200);
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix("RedisKeyLive");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        container.setTaskExecutor((Executor)executor);
        ChannelTopic channelKeyExpire = new ChannelTopic("__keyevent@" + this.redisDb + "__:expired");
        container.addMessageListener((MessageListener)this.messageListener, (Topic)channelKeyExpire);
        return container;
    }

    @Bean
    @ConditionalOnExpression(value="!'${spring.redis.cluster.nodes:}'.isEmpty()&&'${spring.redis.host:}'.isEmpty()")
    public RedisClusterMessageListenerFactory redisMessageListenerFactory(BeanFactory beanFactory, RedisConnectionFactory redisConnectionFactory) {
        RedisClusterMessageListenerFactory beans = new RedisClusterMessageListenerFactory();
        beans.setBeanFactory(beanFactory);
        beans.setRedisConnectionFactory(redisConnectionFactory);
        return beans;
    }
}

