/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.redis.configuration;

import com.zkteco.zkbiosecurity.redis.configuration.KeyExpireMessageListener;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class RedisClusterMessageListenerFactory
implements BeanFactoryAware,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(RedisClusterMessageListenerFactory.class);
    private DefaultListableBeanFactory beanFactory;
    private RedisConnectionFactory redisConnectionFactory;
    @Autowired
    private KeyExpireMessageListener messageListener;
    @Autowired
    private RedisProperties redisProperties;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (DefaultListableBeanFactory)beanFactory;
    }

    public void setRedisConnectionFactory(RedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        RedisClusterConnection redisClusterConnection = this.redisConnectionFactory.getClusterConnection();
        if (redisClusterConnection != null) {
            Iterable nodes = redisClusterConnection.clusterGetNodes();
            for (RedisClusterNode node : nodes) {
                if (!node.isMaster()) continue;
                log.debug("\u83b7\u53d6\u5230redis\u7684master\u8282\u70b9\u4e3a[{}]", (Object)node.toString());
                String hostPort = String.valueOf(node.getHost()) + ":" + node.getPort();
                String containerBeanName = "messageContainer" + node.hashCode();
                if (this.beanFactory.containsBean(containerBeanName)) {
                    return;
                }
                RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration(node.getHost(), node.getPort().intValue());
                redisStandaloneConfiguration.setPassword(RedisPassword.of((String)this.redisProperties.getPassword()));
                LettuceConnectionFactory factory = new LettuceConnectionFactory(redisStandaloneConfiguration);
                factory.afterPropertiesSet();
                BeanDefinitionBuilder containerBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(RedisMessageListenerContainer.class);
                containerBeanDefinitionBuilder.addPropertyValue("connectionFactory", (Object)factory);
                containerBeanDefinitionBuilder.setScope("singleton");
                containerBeanDefinitionBuilder.setLazyInit(false);
                this.beanFactory.registerBeanDefinition(containerBeanName, (BeanDefinition)containerBeanDefinitionBuilder.getRawBeanDefinition());
                String listenerBeanName = "messageListener" + node.hashCode();
                if (this.beanFactory.containsBean(listenerBeanName)) {
                    return;
                }
                RedisMessageListenerContainer container = (RedisMessageListenerContainer)this.beanFactory.getBean(containerBeanName, RedisMessageListenerContainer.class);
                container.setConnectionFactory((RedisConnectionFactory)factory);
                ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
                executor.setCorePoolSize(10);
                executor.setMaxPoolSize(100);
                executor.setQueueCapacity(200);
                executor.setKeepAliveSeconds(60);
                executor.setThreadNamePrefix("RedisKeyLive");
                executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
                executor.initialize();
                container.setTaskExecutor((Executor)executor);
                ChannelTopic channelTopic = new ChannelTopic("__keyevent@0__:expired");
                container.addMessageListener((MessageListener)this.messageListener, (Topic)channelTopic);
                container.afterPropertiesSet();
                container.start();
            }
        }
    }
}

