/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.redis.configuration;

import com.zkteco.zkbiosecurity.redis.configuration.RedisKeyExpireCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.stereotype.Component;

@Component
public class KeyExpireMessageListener
implements MessageListener {
    @Autowired(required=false)
    private RedisKeyExpireCallback[] redisKeyExpireCallbacks;
    Logger log = LoggerFactory.getLogger(this.getClass());

    public void onMessage(Message message, byte[] pattern) {
        byte[] body = message.getBody();
        byte[] channel = message.getChannel();
        String topic = new String(channel);
        String key = new String(body);
        this.log.debug("receiver expire topic=" + topic + ",key=" + key);
        if (this.redisKeyExpireCallbacks != null) {
            RedisKeyExpireCallback[] redisKeyExpireCallbackArray = this.redisKeyExpireCallbacks;
            int n = this.redisKeyExpireCallbacks.length;
            int n2 = 0;
            while (n2 < n) {
                RedisKeyExpireCallback redisKeyExpireCallback = redisKeyExpireCallbackArray[n2];
                redisKeyExpireCallback.keyExireNotify(key);
                ++n2;
            }
        }
    }
}

