/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.redis.aspect;

import com.zkteco.zkbiosecurity.base.annotation.ZkCacheDelete;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CacheAspect {
    @Resource
    private RedisTemplate<String, String> redisTemplate;

    @Around(value="@annotation(zkCacheDelete)")
    public Object invoke(ProceedingJoinPoint joinPoint, ZkCacheDelete zkCacheDelete) throws Throwable {
        if (zkCacheDelete.beforeInvocation()) {
            this.deleteKey(joinPoint, zkCacheDelete);
            return joinPoint.proceed();
        }
        Object proceed = joinPoint.proceed();
        this.deleteKey(joinPoint, zkCacheDelete);
        return proceed;
    }

    private void deleteKey(ProceedingJoinPoint joinPoint, ZkCacheDelete zkCacheDelete) {
        String ids = this.getExpressionValue(joinPoint, zkCacheDelete.key());
        String[] stringArray = zkCacheDelete.value();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cacheName = stringArray[n2];
            String[] idArray = ids.split(",");
            if (idArray != null && idArray.length > 0) {
                String[] stringArray2 = idArray;
                int n3 = idArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String key = stringArray2[n4];
                    key = "cache:" + cacheName + ":" + key;
                    this.redisTemplate.delete((Object)key);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private String getExpressionValue(ProceedingJoinPoint joinPoint, String key) {
        SpelExpressionParser expressionParser = new SpelExpressionParser();
        Expression expression = expressionParser.parseExpression(key);
        StandardEvaluationContext context = new StandardEvaluationContext();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String[] parameterNames = methodSignature.getParameterNames();
        Object[] args = joinPoint.getArgs();
        int i = 0;
        while (i < parameterNames.length) {
            context.setVariable(parameterNames[i], args[i]);
            ++i;
        }
        return String.valueOf(expression.getValue((EvaluationContext)context));
    }
}

