/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.web.cache;

import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class ProgressCache {
    private static Logger logger = LoggerFactory.getLogger(ProgressCache.class);
    private String clientId = "processRate_";
    @Resource
    private RedisTemplate<String, ProcessBean> template;

    public String getClientId() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        if (request != null) {
            if (request.getParameter("clientId") != null) {
                this.clientId = request.getParameter("clientId");
            }
        } else {
            this.clientId = "processRate_" + System.currentTimeMillis();
        }
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    private void setProcessToRedis(ProcessBean processBean) {
        this.template.opsForValue().set((Object)this.getClientId(), (Object)processBean, 30L, TimeUnit.MINUTES);
    }

    private ProcessBean getProcessFromRedis() {
        ProcessBean bean = (ProcessBean)this.template.opsForValue().get((Object)this.getClientId());
        return bean == null ? new ProcessBean() : bean;
    }

    public ProcessBean getProcess() {
        ProcessBean processBean = new ProcessBean();
        try {
            processBean = this.getProcessFromRedis();
        }
        catch (Exception e) {
            logger.error("exception\uff1a", (Throwable)e);
        }
        return processBean;
    }

    public void setProcess(ProcessBean processBean) {
        try {
            ProcessBean oldpProcessBean = this.getProcessFromRedis();
            processBean.setProgressContent(String.valueOf(oldpProcessBean.getProgressContent()) + processBean.getProgressContent());
            this.setProcessToRedis(processBean);
        }
        catch (Exception e) {
            logger.error("exception\uff1a", (Throwable)e);
        }
    }

    public void setProcess(ProcessBean processBean, String clientId) {
        try {
            ProcessBean oldpProcessBean = (ProcessBean)this.template.opsForValue().get((Object)clientId);
            if (oldpProcessBean == null) {
                oldpProcessBean = new ProcessBean();
            }
            processBean.setProgressContent(String.valueOf(oldpProcessBean.getProgressContent()) + processBean.getProgressContent());
            this.template.opsForValue().set((Object)clientId, (Object)processBean, 30L, TimeUnit.MINUTES);
        }
        catch (Exception var3) {
            logger.error("exception\uff1a", (Throwable)var3);
        }
    }

    public void beginProcess(ProcessBean processBean) {
        this.beginProcess("${common_op_startProcessing}<br/>");
    }

    public void beginProcess(String progressContent) {
        this.beginProcess(progressContent, null, null);
    }

    public void beginProcess(String progressContent, String currentProgressTitle) {
        this.beginProcess(progressContent, currentProgressTitle, null);
    }

    public void beginProcess(String progressContent, String currentProgressTitle, String totalProgressTitle) {
        this.setProcess(new ProcessBean(0, 0, progressContent, currentProgressTitle, totalProgressTitle));
    }

    public void finishProcess(String progressContent) {
        this.finishProcess(progressContent, null, null);
    }

    public void finishProcess(String progressContent, String currentProgressTitle) {
        this.finishProcess(progressContent, currentProgressTitle, null);
    }

    public void finishProcess(String progressContent, String currentProgressTitle, String totalProgressTitle) {
        this.setProcess(new ProcessBean(100, 100, progressContent, currentProgressTitle, totalProgressTitle));
    }
}

