/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.line.init;

import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=315)
public class LineInit
implements CommandLineRunner {
    @Autowired(required=false)
    private AuthPermissionService authPermissionService;
    @Autowired(required=false)
    private BaseSysParamService baseSysParamService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("LineInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initLineParams();
            this.baseSysParamService.setAlreadyInitModule("LineInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem subMenuItem1;
        AuthPermissionItem systemItem = this.authPermissionService.getItemByCode("System");
        if (systemItem == null) {
            systemItem = new AuthPermissionItem("System", "system_module", "system", "system", "true", Integer.valueOf(999));
            systemItem = this.authPermissionService.initData(systemItem);
        }
        if ((subMenuItem1 = this.authPermissionService.getItemByCode("ThirdPartyDocking")) == null) {
            subMenuItem1 = new AuthPermissionItem("ThirdPartyDocking", "base_leftMenu_thirdParty", "third:party:docking", "menu", "true", Integer.valueOf(4));
            subMenuItem1.setParentId(systemItem.getId());
            subMenuItem1.setImg("base_extendManage.png");
            subMenuItem1.setImgHover("base_extendManage_over.png");
            subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        }
        AuthPermissionItem subMenuItem = new AuthPermissionItem("LineNotification", "line_notification", "line:notification", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("lineNotification.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("LineNotificationAdd", "common_op_new", "line:notification:add", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LineNotificationRefresh", "common_op_refresh", "line:notification:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LineNotificationDel", "common_op_del", "line:notification:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LineNotificationEdit", "common_op_edit", "line:notification:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("LineNotificationSetContact", "line_notification_setContact", "line:notification:setContact", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
    }

    private void initLineParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("line.version", "true", "line version", Boolean.valueOf(true)));
    }
}

