/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ACC_PERSON_PERSONLIMITZONE t Left JOIN PERS_PERSON p ON t.PERS_PERSON_ID = p.ID LEFT JOIN ACC_PERSONLIMIT_ZONE az on az.id = t.ACC_PERSONLIMITZONE_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=235, winWidth=520, operates={@GridOperate(type="custom", permission="acc:personLimitZone:resetPersonRule", filter="accPersonPersonLimitZoneShowReset", click="resetPersonPersonLimitZone", label="common_op_reset")})
public class AccPersonPersonLimitZoneItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40")
    private String id;
    @Column(name="t.PERS_PERSON_ID")
    @GridColumn(label="")
    private String persPersonId;
    @Column(name="p.pin")
    @GridColumn(label="pers_person_pin", width="90", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String persPin;
    @Column(name="p.NAME")
    @GridColumn(label="pers_person_name", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String name;
    @Column(name="p.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", width="100", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String lastName;
    @Condition(value="(LOWER (p.NAME) LIKE LOWER (''%{0}%'') OR LOWER (p.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @GridColumn(label="acc_personLimit_detail", width="200", sort="na")
    private String detail;
    @Condition(value="p.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Column(name="t.ACC_PERSONLIMITZONE_ID", equalTag="=")
    private String personLimitZoneId;
    @Column(name="az.VALID_TYPE")
    private String validType;
    @Column(name="az.ZONE_ID")
    private String zoneId;
    @Column(name="az.VALID_DATE_TIME")
    private String validDateTime;

    public AccPersonPersonLimitZoneItem() {
    }

    public AccPersonPersonLimitZoneItem(Boolean equals) {
        super(equals);
    }

    public String getId() {
        return this.id;
    }

    public String getPersPersonId() {
        return this.persPersonId;
    }

    public String getPersPin() {
        return this.persPin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPersonLimitZoneId() {
        return this.personLimitZoneId;
    }

    public String getValidType() {
        return this.validType;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getValidDateTime() {
        return this.validDateTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPersPersonId(String persPersonId) {
        this.persPersonId = persPersonId;
    }

    public void setPersPin(String persPin) {
        this.persPin = persPin;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setLikeName(String likeName) {
        this.likeName = likeName;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPersonLimitZoneId(String personLimitZoneId) {
        this.personLimitZoneId = personLimitZoneId;
    }

    public void setValidType(String validType) {
        this.validType = validType;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public void setValidDateTime(String validDateTime) {
        this.validDateTime = validDateTime;
    }
}

