/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ACC_MUSTERPOINT_REPORT t ")
@OrderBy(after="t.status desc")
@GridConfig(operate=false, idField="id")
public class AccMusterPointReportItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(show=false)
    private String id;
    @Column(name="t.ENTER_TIME")
    @GridColumn(label="common_time", width="180")
    private Date enterTime;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="110", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String pin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="110", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="110", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String lastName;
    @Condition(value="t.DEPT_NAME", equalTag="like")
    @Column(name="t.DEPT_NAME")
    private String deptName;
    @Column(name="t.MOBILE_PHONE", encryptConverter=true)
    @GridColumn(label="pers_person_mobilePhone", width="80", encryptMode="${pers.mobilePhone.encryptMode}", encryptProp="${pers.mobilePhone.encryptProp}")
    private String mobilePhone;
    @GridColumn(label="acc_musterPoint_signPoint", i18n=true, width="150")
    @Column(name="t.SIGN_POINT_NAME")
    private String signPointName;
    @Column(name="t.MUSTER_POINT_NAME")
    private String musterPointName;
    @Column(name="t.STATUS", equalTag="=")
    @GridColumn(label="common_status", width="100", columnType="custom", convert="convertStatus")
    private String status;
    @Condition(value="(LOWER(t.NAME) LIKE LOWER(''%{0}%'') OR LOWER(t.LAST_NAME) LIKE LOWER(''%{0}%''))")
    private String likeName;
    @Condition(value="t.MUSTER_POINT_NAME", equalTag="=")
    private String musterPointNameEq;
    @Condition(value="t.MUSTER_POINT_Id", equalTag="=")
    private String musterPointIdEq;
    @Column(name="t.MUSTER_POINT_Id", equalTag="=")
    private String musterPointId;
    @Column(name="t.DEPT_CODE")
    @Condition(value="t.DEPT_CODE", equalTag="=")
    private String deptCode;
    @Column(name="t.AREA_NAME")
    private String areaName;
    @Condition(value="t.ENTER_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.ENTER_TIME", equalTag=">")
    private Date afterTime;
    @Condition(value="t.ENTER_TIME", equalTag="<=")
    private Date endTime;
    @Condition(value="(t.DEPT_CODE IN (SELECT ad.CODE FROM AUTH_DEPARTMENT ad LEFT JOIN AUTH_USER_DEPT au ON ad.ID = au.AUTH_DEPT_ID WHERE au.AUTH_USER_ID=''{0}'') or t.DEPT_CODE is null or t.DEPT_CODE = '''' or t.DEPT_CODE = ''vis'')")
    private String deptCodeInByUserId;
    private String personType;
    @Condition(value="t.DEPT_CODE", equalTag="!=")
    private String deptCodeNoEq;

    public String getId() {
        return this.id;
    }

    public Date getEnterTime() {
        return this.enterTime;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public String getSignPointName() {
        return this.signPointName;
    }

    public String getMusterPointName() {
        return this.musterPointName;
    }

    public String getStatus() {
        return this.status;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getMusterPointNameEq() {
        return this.musterPointNameEq;
    }

    public String getMusterPointIdEq() {
        return this.musterPointIdEq;
    }

    public String getMusterPointId() {
        return this.musterPointId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getAfterTime() {
        return this.afterTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getDeptCodeInByUserId() {
        return this.deptCodeInByUserId;
    }

    public String getPersonType() {
        return this.personType;
    }

    public String getDeptCodeNoEq() {
        return this.deptCodeNoEq;
    }

    public AccMusterPointReportItem setId(String id) {
        this.id = id;
        return this;
    }

    public AccMusterPointReportItem setEnterTime(Date enterTime) {
        this.enterTime = enterTime;
        return this;
    }

    public AccMusterPointReportItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public AccMusterPointReportItem setName(String name) {
        this.name = name;
        return this;
    }

    public AccMusterPointReportItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public AccMusterPointReportItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AccMusterPointReportItem setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public AccMusterPointReportItem setSignPointName(String signPointName) {
        this.signPointName = signPointName;
        return this;
    }

    public AccMusterPointReportItem setMusterPointName(String musterPointName) {
        this.musterPointName = musterPointName;
        return this;
    }

    public AccMusterPointReportItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public AccMusterPointReportItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AccMusterPointReportItem setMusterPointNameEq(String musterPointNameEq) {
        this.musterPointNameEq = musterPointNameEq;
        return this;
    }

    public AccMusterPointReportItem setMusterPointIdEq(String musterPointIdEq) {
        this.musterPointIdEq = musterPointIdEq;
        return this;
    }

    public AccMusterPointReportItem setMusterPointId(String musterPointId) {
        this.musterPointId = musterPointId;
        return this;
    }

    public AccMusterPointReportItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AccMusterPointReportItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public AccMusterPointReportItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public AccMusterPointReportItem setAfterTime(Date afterTime) {
        this.afterTime = afterTime;
        return this;
    }

    public AccMusterPointReportItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public AccMusterPointReportItem setDeptCodeInByUserId(String deptCodeInByUserId) {
        this.deptCodeInByUserId = deptCodeInByUserId;
        return this;
    }

    public AccMusterPointReportItem setPersonType(String personType) {
        this.personType = personType;
        return this;
    }

    public AccMusterPointReportItem setDeptCodeNoEq(String deptCodeNoEq) {
        this.deptCodeNoEq = deptCodeNoEq;
        return this;
    }

    public String toString() {
        return "AccMusterPointReportItem(id=" + this.getId() + ", enterTime=" + this.getEnterTime() + ", pin=" + this.getPin() + ", name=" + this.getName() + ", lastName=" + this.getLastName() + ", deptName=" + this.getDeptName() + ", mobilePhone=" + this.getMobilePhone() + ", signPointName=" + this.getSignPointName() + ", musterPointName=" + this.getMusterPointName() + ", status=" + this.getStatus() + ", likeName=" + this.getLikeName() + ", musterPointNameEq=" + this.getMusterPointNameEq() + ", musterPointIdEq=" + this.getMusterPointIdEq() + ", musterPointId=" + this.getMusterPointId() + ", deptCode=" + this.getDeptCode() + ", areaName=" + this.getAreaName() + ", startTime=" + this.getStartTime() + ", afterTime=" + this.getAfterTime() + ", endTime=" + this.getEndTime() + ", deptCodeInByUserId=" + this.getDeptCodeInByUserId() + ", personType=" + this.getPersonType() + ", deptCodeNoEq=" + this.getDeptCodeNoEq() + ")";
    }
}

