/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ACC_GLOBALLINKAGE_PERSON t LEFT JOIN ACC_GLOBALLINKAGE gl ON t.LINKAGE_ID=gl.ID Left join PERS_PERSON p on p.id = t.PERS_PERSON_ID LEFT join AUTH_DEPARTMENT d on p.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class AccGlobalLinkagePersonItem
extends BaseItem {
    @Column(name="p.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="p.PIN")
    @GridColumn(label="pers_person_pin", sortNo=1, width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @Column(name="p.NAME")
    @GridColumn(label="pers_person_name", sortNo=2, width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="p.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="100", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @Column(name="d.NAME")
    private String deptName;
    @Column(name="t.LINKAGE_ID", equalTag="=")
    private String linkId;
    @Condition(value="(LOWER (p.NAME) LIKE LOWER (''%{0}%'') OR LOWER (p.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Column(name="t.LINKAGE_ID")
    private String globalLinkId;
    @Condition(value="d.ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getGlobalLinkId() {
        return this.globalLinkId;
    }

    public String getUserId() {
        return this.userId;
    }

    public AccGlobalLinkagePersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public AccGlobalLinkagePersonItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AccGlobalLinkagePersonItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AccGlobalLinkagePersonItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AccGlobalLinkagePersonItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AccGlobalLinkagePersonItem setLinkId(String linkId) {
        this.linkId = linkId;
        return this;
    }

    public AccGlobalLinkagePersonItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AccGlobalLinkagePersonItem setGlobalLinkId(String globalLinkId) {
        this.globalLinkId = globalLinkId;
        return this;
    }

    public AccGlobalLinkagePersonItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }
}

