/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON t LEFT JOIN PERS_CARD pc ON t.ID = pc.PERSON_ID LEFT JOIN AUTH_DEPARTMENT d ON t.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class AccAdvancedSelectPersonItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    private String personId;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", sortNo=1, width="90")
    private String personPin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", sortNo=2, width="90")
    private String personName;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="90")
    private String personLastName;
    @Column(name="pc.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", sortNo=4, sort="na", width="65", show=false)
    private String cardNo;
    @Column(name="t.GENDER")
    @GridColumn(label="pers_person_gender", format="F=pers_person_female,M=pers_person_male,U=common_unknown,=---", sortNo=5, width="60", sort="na")
    private String gender;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_entity", sortNo=6, sort="na")
    private String deptName;
    private String beginPin;
    private String endPin;
    private String type;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="t.ID", equalTag="not in")
    private String selectId;
    private String linkId;
    private String modelType;
    @Condition(value="d.ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.ID NOT IN (SELECT apg.PERS_PERSON_ID FROM ACC_PERSON_GLOBALAPB apg WHERE apg.ACC_GLOBALAPB_ID=''{0}'')")
    private String globalApbId;
    @Condition(value="t.ID NOT IN (SELECT agp.PERS_PERSON_ID FROM ACC_GLOBALLINKAGE_PERSON agp WHERE agp.LINKAGE_ID=''{0}'')")
    private String globalLinkId;
    @Column(name="t.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getGender() {
        return this.gender;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getBeginPin() {
        return this.beginPin;
    }

    public String getEndPin() {
        return this.endPin;
    }

    public String getType() {
        return this.type;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getGlobalApbId() {
        return this.globalApbId;
    }

    public String getGlobalLinkId() {
        return this.globalLinkId;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public AccAdvancedSelectPersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public AccAdvancedSelectPersonItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public AccAdvancedSelectPersonItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AccAdvancedSelectPersonItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AccAdvancedSelectPersonItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AccAdvancedSelectPersonItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public AccAdvancedSelectPersonItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public AccAdvancedSelectPersonItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AccAdvancedSelectPersonItem setBeginPin(String beginPin) {
        this.beginPin = beginPin;
        return this;
    }

    public AccAdvancedSelectPersonItem setEndPin(String endPin) {
        this.endPin = endPin;
        return this;
    }

    public AccAdvancedSelectPersonItem setType(String type) {
        this.type = type;
        return this;
    }

    public AccAdvancedSelectPersonItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AccAdvancedSelectPersonItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public AccAdvancedSelectPersonItem setLinkId(String linkId) {
        this.linkId = linkId;
        return this;
    }

    public AccAdvancedSelectPersonItem setModelType(String modelType) {
        this.modelType = modelType;
        return this;
    }

    public AccAdvancedSelectPersonItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public AccAdvancedSelectPersonItem setGlobalApbId(String globalApbId) {
        this.globalApbId = globalApbId;
        return this;
    }

    public AccAdvancedSelectPersonItem setGlobalLinkId(String globalLinkId) {
        this.globalLinkId = globalLinkId;
        return this;
    }

    public AccAdvancedSelectPersonItem setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
        return this;
    }
}

