/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON t LEFT join AUTH_DEPARTMENT d on t.auth_dept_id = d.id ")
@OrderBy(after="t.UPDATE_TIME ASC")
@GridConfig(operate=false, idField="id")
public class AccAdvancedPersonSelectItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40")
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin")
    private String persPin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="65")
    private String persName;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", width="65")
    private String persLastName;
    private String cardNo;
    @Column(name="t.GENDER")
    private String gender;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_entity", width="*")
    private String deptName;
    private String type;
    @Condition(value="t.ID", equalTag="not in")
    private String selectId;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="t.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    private String validType;
    private String zoneId;
    @Column(name="t.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;

    public String getId() {
        return this.id;
    }

    public String getPersPin() {
        return this.persPin;
    }

    public String getPersName() {
        return this.persName;
    }

    public String getPersLastName() {
        return this.persLastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getGender() {
        return this.gender;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getType() {
        return this.type;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getValidType() {
        return this.validType;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public AccAdvancedPersonSelectItem setId(String id) {
        this.id = id;
        return this;
    }

    public AccAdvancedPersonSelectItem setPersPin(String persPin) {
        this.persPin = persPin;
        return this;
    }

    public AccAdvancedPersonSelectItem setPersName(String persName) {
        this.persName = persName;
        return this;
    }

    public AccAdvancedPersonSelectItem setPersLastName(String persLastName) {
        this.persLastName = persLastName;
        return this;
    }

    public AccAdvancedPersonSelectItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public AccAdvancedPersonSelectItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public AccAdvancedPersonSelectItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AccAdvancedPersonSelectItem setType(String type) {
        this.type = type;
        return this;
    }

    public AccAdvancedPersonSelectItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public AccAdvancedPersonSelectItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AccAdvancedPersonSelectItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public AccAdvancedPersonSelectItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AccAdvancedPersonSelectItem setValidType(String validType) {
        this.validType = validType;
        return this;
    }

    public AccAdvancedPersonSelectItem setZoneId(String zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    public AccAdvancedPersonSelectItem setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
        return this;
    }

    public String toString() {
        return "AccAdvancedPersonSelectItem(id=" + this.getId() + ", persPin=" + this.getPersPin() + ", persName=" + this.getPersName() + ", persLastName=" + this.getPersLastName() + ", cardNo=" + this.getCardNo() + ", gender=" + this.getGender() + ", deptName=" + this.getDeptName() + ", type=" + this.getType() + ", selectId=" + this.getSelectId() + ", likeName=" + this.getLikeName() + ", userId=" + this.getUserId() + ", inDeptId=" + this.getInDeptId() + ", validType=" + this.getValidType() + ", zoneId=" + this.getZoneId() + ", enabledCredential=" + this.getEnabledCredential() + ")";
    }
}

