/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.client.service.impl;

import com.alibaba.fastjson.JSON;
import com.zkteco.cloud.sdk.bean.FileBean;
import com.zkteco.cloud.sdk.resp.BaseResponse;
import com.zkteco.cloud.sdk.util.ZKCloudApiFileUploadUtil;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.license.provider.BaseLicenseProvider;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.system.app.service.BaseAuthCloudMessageSendService;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryValueItem;
import com.zkteco.zkbiosecurity.vis.service.VisCloudService;
import com.zkteco.zkbiosecurity.vis.service.VisReservationService;
import com.zkteco.zkbiosecurity.vis.service.VisTransactionLinkService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitedPersonService;
import com.zkteco.zkbiosecurity.vis.vo.VisReservationItem;
import com.zkteco.zkbiosecurity.vis.vo.VisTransactionItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitedPersonItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitorItem;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class VisCloudServiceImpl
implements VisCloudService {
    private static final Logger logger = LoggerFactory.getLogger(VisCloudServiceImpl.class);
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;
    @Autowired
    private VisVisitedPersonService visVisitedPersonService;
    @Autowired
    private BaseLicenseProvider baseLicenseProvider;
    @Autowired(required=false)
    private BaseAuthCloudMessageSendService industrial4BaseDataService;
    @Autowired
    private VisReservationService visReservationService;
    @Value(value="${cloud.server.file.url:http://192.168.213.50:9888/portal/file/upload}")
    private String cloudServerFileUrl;
    @Autowired(required=false)
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private VisTransactionLinkService visTransactionLinkService;

    public void syncPushVisitedPersonToCloud(List<VisVisitedPersonItem> visVisitedPersonItemList) {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.isActiveLicense() && !CollectionUtil.isEmpty(visVisitedPersonItemList)) {
                List visVisitedPersonItemsList = CollectionUtil.split(visVisitedPersonItemList, (int)30);
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setModuleCode("vis");
                zkMessage.setMessageId("visCloudReservationHandleMessage#visitedPersonMessageHandle");
                visVisitedPersonItemsList.forEach(visVisitedPersonItems -> {
                    zkMessage.setListContent(visVisitedPersonItems);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                });
            }
        }
        catch (Exception e) {
            logger.error("----VisCloudServiceImpl syncPushVisitedPersonToCloud error---:", (Throwable)e);
        }
    }

    public void asyncDelVisVisitedPersonToCloud(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List visVisitedPersonItems = this.visVisitedPersonService.getItemByIds(ids);
            this.delVisVisitedPersonToCloud(visVisitedPersonItems);
        }
    }

    public void asyncDelVisitedPersonToCloudByPersonId(String personIds) {
        if (StringUtils.isNotBlank((CharSequence)personIds)) {
            List visVisitedPersonItems = this.visVisitedPersonService.getItemByPersonIds(personIds);
            this.delVisVisitedPersonToCloud(visVisitedPersonItems);
        }
    }

    private void delVisVisitedPersonToCloud(List<VisVisitedPersonItem> visVisitedPersonItems) {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.isActiveLicense() && !CollectionUtil.isEmpty(visVisitedPersonItems)) {
            CompletableFuture.runAsync(() -> {
                Collection allPins = CollectionUtil.getPropertyList((Collection)visVisitedPersonItems, VisVisitedPersonItem::getPersonPin, (Object)"-1");
                List pinsList = CollectionUtil.split((Collection)allPins, (int)30);
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setModuleCode("vis");
                zkMessage.setMessageId("visCloudReservationHandleMessage#delVisitedPersonByPin");
                zkMessage.setAppId(this.baseLicenseService.getAppId());
                pinsList.forEach(pins -> {
                    zkMessage.setListContent(pins);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                });
            });
        }
    }

    public void asyncPushTransactionToCloud(List<VisTransactionItem> visTransactionItemLists) {
    }

    public void asyncPushVisReservationVisitedToCloud(List<VisReservationItem> visReservationItemList) {
    }

    public boolean isActiveLicense() {
        List activeModuleCodeList = this.baseLicenseProvider.getActiveModuleLIist();
        return activeModuleCodeList.contains("vis");
    }

    public void asyncPushReservationToCloud(List<VisReservationItem> visReservationItemList) {
        if (this.industrial4BaseDataService.isAllowSendBusinessData() && this.isActiveLicense() && !CollectionUtil.isEmpty(visReservationItemList)) {
            String ids = CollectionUtil.getItemIds(visReservationItemList);
            List visReservationItems = this.visReservationService.getItemsByIds(ids);
            List valueItems = this.baseDictionaryValueService.getDictionaryValues("certificateType");
            Map map = CollectionUtil.listToKeyMap((Collection)valueItems, BaseDictionaryValueItem::getCode);
            Iterator iterator = visReservationItems.iterator();
            while (iterator.hasNext()) {
                ZKResultMsg zkResultMsg;
                VisReservationItem visReservationItem;
                visReservationItem.setCertName(map.get((visReservationItem = (VisReservationItem)iterator.next()).getCertType()) == null ? "" : ((BaseDictionaryValueItem)map.get(visReservationItem.getCertType())).getDictValue());
                if (StringUtils.isNotBlank((CharSequence)visReservationItem.getPhotoPath()) && Objects.nonNull((zkResultMsg = this.upload(visReservationItem.getPhotoPath(), "vis/" + this.baseLicenseService.getAppId() + "/" + VisCloudServiceImpl.getDatePhotoPath(), visReservationItem.getId(), System.currentTimeMillis() + ".png")).getData())) {
                    visReservationItem.setPhotoPath(zkResultMsg.getData().toString());
                }
                if (StringUtils.isNotBlank((CharSequence)visReservationItem.getCropPhotoPath()) && Objects.nonNull((zkResultMsg = this.upload(visReservationItem.getCropPhotoPath(), "vis/" + this.baseLicenseService.getAppId() + "/cropFace/" + VisCloudServiceImpl.getDatePhotoPath(), visReservationItem.getId(), System.currentTimeMillis() + ".png")).getData())) {
                    visReservationItem.setCropPhotoPath(zkResultMsg.getData().toString());
                }
                visReservationItem.setVisitCode(visReservationItem.getVisitNumber());
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setModuleCode("vis");
                zkMessage.setMessageId("visCloudReservationHandleMessage#handleReservationMessage");
                zkMessage.setAppId(this.baseLicenseService.getAppId());
                zkMessage.setListContent(Collections.singletonList(visReservationItem));
                this.baseLicenseClientService.sendMessage(zkMessage);
            }
        }
    }

    public static String getDatePhotoPath() {
        return DateUtil.dateToString((Date)new Date(), (String)DateUtil.DateStyle.YYYY_MM_DD.getValue());
    }

    public String buildBioPhoto(String photoPath) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{photoPath})) {
            String base64Photo = FileEncryptUtil.getDecryptFileBase64((String)photoPath);
            return base64Photo.replaceAll("\r\n", "").replaceAll("\t", "");
        }
        return "";
    }

    private ZKResultMsg upload(String photoPath, String path, String fileId, String fileName) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String base64Image = this.buildBioPhoto(photoPath);
        try {
            FileBean fileBean = new FileBean();
            fileBean.setModuleName("vis");
            fileBean.setAppId(this.baseLicenseClientService.getAppid());
            fileBean.setAppKey(this.baseLicenseClientService.getAppKey());
            fileBean.setBase64Image(base64Image);
            fileBean.setCloudServerFileUrl(this.cloudServerFileUrl);
            BaseResponse response = ZKCloudApiFileUploadUtil.upload((FileBean)fileBean);
            zkResultMsg = (ZKResultMsg)JSON.parseObject((String)response.getBody(), ZKResultMsg.class);
        }
        catch (Exception e) {
            zkResultMsg.setData((Object)"upload fail");
            zkResultMsg.setRet("fail");
        }
        return zkResultMsg;
    }

    public void asyncPushTransactionAndSmsStatusToCloud(List<VisTransactionItem> visTransactionItemList) {
    }

    public ZKResultMsg asyncPushVisitorToCloud(List<VisVisitorItem> itemList) {
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg delVisitorToCloud(List<VisVisitorItem> items) {
        return ZKResultMsg.successMsg();
    }

    public void asyncPushNotifyMsgToCloud(List<VisReservationItem> visReservationItemList) {
        if (this.industrial4BaseDataService.isAllowSendBusinessData() && StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.isActiveLicense() && !CollectionUtil.isEmpty(visReservationItemList)) {
            CompletableFuture.runAsync(() -> {
                List visReservationItemsList = CollectionUtil.split((Collection)visReservationItemList, (int)30);
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setModuleCode("vis");
                zkMessage.setMessageId("visCloudHandleMessage#sendVisMessage");
                visReservationItemsList.forEach(visReservationItems -> {
                    zkMessage.setListContent(visReservationItems);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                });
            });
        }
    }
}

