/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.client.service;

import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.vis.client.utils.VisUploadPageUtil;
import com.zkteco.zkbiosecurity.vis.service.VisCloudService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitedPersonService;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitedPersonItem;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class VisVisitedPersonMessageUpload {
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired(required=false)
    private VisVisitedPersonService visVisitedPersonService;
    @Autowired
    private VisCloudService visCloudService;

    @Scheduled(cron="0 0/5 * * * ?")
    public void visitedPersonMessageUpload() {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.visCloudService.isActiveLicense()) {
            Long pushTime = this.visVisitedPersonService.getLastPushTime();
            if (pushTime == null || pushTime == 0L) {
                Long visitedPersonCount = this.visVisitedPersonService.getVisitedPersonCount();
                int pageNo = VisUploadPageUtil.getPage(visitedPersonCount);
                for (int i = 0; i < pageNo; ++i) {
                    Pager pager = this.visVisitedPersonService.getItemsByPage((BaseItem)new VisVisitedPersonItem(), i, 30);
                    List visVisitedPersonItemList = pager.getData();
                    if (visVisitedPersonItemList == null || visVisitedPersonItemList.isEmpty()) continue;
                    this.visCloudService.syncPushVisitedPersonToCloud(visVisitedPersonItemList);
                }
            } else {
                Date lastUpdate = new Date(pushTime);
                List visVisitedPersonItemList = this.visVisitedPersonService.getUpdatePersonItem(lastUpdate = DateUtil.addMinute((Date)lastUpdate, (int)-1));
                if (visVisitedPersonItemList != null && !visVisitedPersonItemList.isEmpty()) {
                    this.visCloudService.syncPushVisitedPersonToCloud(visVisitedPersonItemList);
                }
            }
            this.visVisitedPersonService.setLastPushTime();
        }
    }
}

