/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.client.service;

import com.alibaba.fastjson.JSONArray;
import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.vis.client.utils.MyHttpsConnection;
import com.zkteco.zkbiosecurity.vis.constants.VisConstants;
import com.zkteco.zkbiosecurity.vis.service.VisReservationService;
import com.zkteco.zkbiosecurity.vis.vo.VisReservationItem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@ConditionalOnProperty(value={"vis.visReservationMessageHandle.isExecute"}, havingValue="true", matchIfMissing=true)
@Component
public class VisReservationMessageHandle {
    private static final Logger logger = LoggerFactory.getLogger(VisReservationMessageHandle.class);
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private VisReservationService visReservationService;

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    public ZKResultMsg sendVisReservationMessage(ZKMessage zkMessage) {
        List visReservationMessageList = zkMessage.getListContent();
        if (visReservationMessageList != null && visReservationMessageList.size() > 0) {
            List visReservationItems = JSONArray.parseArray((String)visReservationMessageList.toString(), VisReservationItem.class);
            visReservationItems.forEach(visReservationItem -> {
                this.editVisReservation((VisReservationItem)visReservationItem, VisConstants.RESERVATION_AUDIT, null);
                List followUpVisitItems = visReservationItem.getFollowUpVisitItems();
                if (!CollectionUtil.isEmpty((Collection)followUpVisitItems) && StringUtils.isNotBlank((CharSequence)visReservationItem.getId())) {
                    for (VisReservationItem followUpVisitItem : followUpVisitItems) {
                        followUpVisitItem.setParentReservationId(visReservationItem.getId());
                        this.editVisReservation(followUpVisitItem, VisConstants.RESERVATION_AUDIT, null);
                    }
                }
            });
        }
        return ZKResultMsg.successMsg();
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    public ZKResultMsg sendVisRefuseReservationMessage(ZKMessage zkMessage) {
        List visReservationMessageList = zkMessage.getListContent();
        if (visReservationMessageList != null && visReservationMessageList.size() > 0) {
            List visReservationItems = JSONArray.parseArray((String)visReservationMessageList.toString(), VisReservationItem.class);
            visReservationItems.forEach(visReservationItem -> {
                this.editVisReservation((VisReservationItem)visReservationItem, VisConstants.RESERVATION_REFUSE, "5");
                List followUpVisitItems = visReservationItem.getFollowUpVisitItems();
                if (!CollectionUtil.isEmpty((Collection)followUpVisitItems) && StringUtils.isNotBlank((CharSequence)visReservationItem.getId())) {
                    followUpVisitItems.forEach(followUpVisitItem -> {
                        followUpVisitItem.setParentReservationId(visReservationItem.getId());
                        this.editVisReservation((VisReservationItem)followUpVisitItem, VisConstants.RESERVATION_REFUSE, "5");
                    });
                }
            });
        }
        return ZKResultMsg.successMsg();
    }

    private void editVisReservation(VisReservationItem visReservationItem, Short auditStatus, String isVisited) {
        try {
            PersPersonItem persPersonItem = this.persPersonService.getItemByPin(visReservationItem.getVisitEmpPin());
            if (persPersonItem != null) {
                visReservationItem.setVisitorId("");
                visReservationItem.setVisitEmpName(persPersonItem.getName());
                visReservationItem.setVisitEmpLastName(persPersonItem.getLastName());
                visReservationItem.setVisitedEmpId(persPersonItem.getId());
                visReservationItem.setVisitEmpPin(persPersonItem.getPin());
                visReservationItem.setVisitEmpDeptId(persPersonItem.getDeptId());
                visReservationItem.setVisitEmpDeptName(persPersonItem.getDeptName());
                visReservationItem.setVisitedEmpId(persPersonItem.getId());
                VisReservationItem oldVisReservationItem = this.visReservationService.getItemByCertAndVisitDate(visReservationItem.getCertType(), visReservationItem.getCertNumber(), visReservationItem.getVisitDate(), visReservationItem.getVisitEndDate());
                if (oldVisReservationItem != null) {
                    visReservationItem.setId(oldVisReservationItem.getId());
                    visReservationItem.setPhotoPath(oldVisReservationItem.getPhotoPath());
                    visReservationItem.setCropPhotoPath(oldVisReservationItem.getCropPhotoPath());
                    visReservationItem.setPersonPwd(oldVisReservationItem.getPersonPwd());
                } else {
                    visReservationItem.setId("");
                    if (!"INS".equals(visReservationItem.getIsFrom())) {
                        String downloadPhoto;
                        if (StringUtils.isNotBlank((CharSequence)visReservationItem.getPhotoPath())) {
                            downloadPhoto = this.downloadPhoto(visReservationItem.getPhotoPath(), "vis", "visitor/reservationPhoto", "_" + System.currentTimeMillis() + ".jpg", true);
                            visReservationItem.setPhotoPath(downloadPhoto);
                        }
                        if (StringUtils.isNotBlank((CharSequence)visReservationItem.getCropPhotoPath())) {
                            downloadPhoto = this.downloadPhoto(visReservationItem.getCropPhotoPath(), "vis", "visitor/reservationPhoto/cropFace", "_" + System.currentTimeMillis() + ".jpg", true);
                            visReservationItem.setCropPhotoPath(downloadPhoto);
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)visReservationItem.getParentReservationId()) && visReservationItem.getFollowUpVisitItems() != null && !CollectionUtil.isEmpty((Collection)visReservationItem.getFollowUpVisitItems())) {
                    visReservationItem.setVisitorCount(Integer.valueOf(1));
                }
                visReservationItem.setVisitNumber(visReservationItem.getVisitCode());
                visReservationItem.setCardNo(visReservationItem.getVisitCode());
                visReservationItem.setAuditStatus(auditStatus);
                visReservationItem.setAuditTime(DateUtil.stringToDate((String)DateUtil.dateToString((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS)));
                if (StringUtils.isBlank((CharSequence)visReservationItem.getIsFrom())) {
                    visReservationItem.setIsFrom("VIS_CLOUD_APP");
                }
                if (StringUtils.isNotBlank((CharSequence)isVisited)) {
                    visReservationItem.setIsVisited(isVisited);
                }
                if (StringUtils.isBlank((CharSequence)visReservationItem.getPhotoPath())) {
                    visReservationItem.setPhotoPath(null);
                }
                visReservationItem.setIsSetCommonLevel(Boolean.valueOf(true));
                this.visReservationService.saveItemNew(visReservationItem);
            }
        }
        catch (Exception e) {
            logger.error("visCloud sendVisReservationMessage error: ", (Throwable)e);
        }
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    public ZKResultMsg sendCancelVisReservationMessage(ZKMessage zkMessage) {
        List visReservationMessageList = zkMessage.getListContent();
        if (visReservationMessageList != null && visReservationMessageList.size() > 0) {
            List visReservationItems = JSONArray.parseArray((String)visReservationMessageList.toString(), VisReservationItem.class);
            this.visReservationService.cancelVisReservation(visReservationItems);
        }
        return ZKResultMsg.successMsg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadPhoto(String photoUrl, String model, String business, String fileName, Boolean isEncrypt) {
        if (StringUtils.isNotBlank((CharSequence)photoUrl) && (photoUrl.startsWith("http") || photoUrl.startsWith("https"))) {
            URL url = null;
            HttpURLConnection httpUrl = null;
            InputStream is = null;
            ByteArrayOutputStream outStream = null;
            try {
                if (photoUrl.startsWith("https")) {
                    new MyHttpsConnection();
                }
                url = new URL(photoUrl);
                httpUrl = (HttpURLConnection)url.openConnection();
                httpUrl.setConnectTimeout(3000);
                httpUrl.connect();
                is = httpUrl.getInputStream();
                if (is != null) {
                    outStream = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    while ((len = is.read(buffer)) != -1) {
                        outStream.write(buffer, 0, len);
                    }
                    String photoPath = FileUtil.saveFileToServer((String)model, (String)business, (String)fileName, (String)Base64Utils.encodeToString((byte[])outStream.toByteArray()));
                    if (isEncrypt.booleanValue()) {
                        FileEncryptUtil.encryptFileByPath((String)photoPath);
                        FileEncryptUtil.encryptFileByPath((String)FileUtil.getThumbPath((String)photoPath));
                    }
                    String string = photoPath;
                    return string;
                }
            }
            catch (IOException e) {
                logger.error("Class VisReservationMessageHandle method downloadPhoto", (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (outStream != null) {
                        outStream.close();
                    }
                    if (httpUrl != null) {
                        httpUrl.disconnect();
                    }
                }
                catch (IOException e) {
                    logger.error("Class VisReservationMessageHandle method downloadPhoto", (Throwable)e);
                }
            }
        }
        return null;
    }
}

