/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class ParkGetLocalIpAddrUtil {
    public static String getClientIpAddr(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-Real-IP");
        if (StringUtils.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("X-Forwarded-For");
        }
        if (StringUtils.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_X_FORWARDED");
        }
        if (StringUtils.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_X_CLUSTER_CLIENT_IP");
        }
        if (StringUtils.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtils.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_FORWARDED_FOR");
        }
        if (StringUtils.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_FORWARDED");
        }
        if ((StringUtils.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && ("127.0.0.1".equals(ipAddress = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ipAddress))) {
            try {
                InetAddress inet = InetAddress.getLocalHost();
                ipAddress = inet.getHostAddress();
                System.out.println(inet.getAddress());
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)ipAddress) && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            String[] ips;
            for (String temp : ips = ipAddress.split(",")) {
                if ((temp = temp.toLowerCase()).contains("unknown")) continue;
                ipAddress = temp;
            }
        }
        return ipAddress;
    }

    public static List<String> getServerAllIPAddr() {
        ArrayList<String> ipList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address) || "127.0.0.1".equals(ip.getHostAddress())) continue;
                    ipList.add(ip.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return ipList;
    }

    public static boolean ipCheck(String ipAddress) {
        if (StringUtils.isBlank((CharSequence)ipAddress)) {
            return false;
        }
        if (ipAddress.length() < 7 || ipAddress.length() > 15) {
            return false;
        }
        char[] ipChars = ipAddress.toCharArray();
        int length = ipChars.length;
        int ipUnitIntValue = -1;
        boolean isFirstUnit = true;
        int unitsCount = 0;
        for (int i = 0; i < length; ++i) {
            char c = ipChars[i];
            if (c == '.') {
                if (ipUnitIntValue < 0 || ipUnitIntValue > 255) {
                    return false;
                }
                if (isFirstUnit && ipUnitIntValue == 0) {
                    return false;
                }
                if (isFirstUnit) {
                    isFirstUnit = false;
                }
                ipUnitIntValue = -1;
                ++unitsCount;
                continue;
            }
            if (c < '0' || c > '9') {
                return false;
            }
            if (ipUnitIntValue == -1) {
                ipUnitIntValue = 0;
            }
            ipUnitIntValue = ipUnitIntValue * 10 + (c - 48);
        }
        if (ipUnitIntValue < 0 || ipUnitIntValue > 255) {
            return false;
        }
        return unitsCount == 3;
    }
}

