/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.park.remote.ParkWorkRecordRemote;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingLotService;
import com.zkteco.zkbiosecurity.park.service.ParkWorkRecordService;
import com.zkteco.zkbiosecurity.park.vo.ParkWorkRecordItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkWorkRecordController
extends ExportController
implements ParkWorkRecordRemote {
    @Autowired
    private ParkWorkRecordService parkWorkRecordService;
    @Autowired
    private ParkParkingLotService parkParkingLotService;
    @Autowired
    private ParkParamsService parkParamsService;

    @RequiresPermissions(value={"park:workRecord"})
    public ModelAndView index() {
        if (!"zkteco-park".equals(this.parkParamsService.getParkingLotCommMode())) {
            this.request.setAttribute("showColumns", (Object)"!parkingLotInfName");
        }
        return new ModelAndView("park/workRecord/parkWorkRecord");
    }

    public DxGrid list(ParkWorkRecordItem codition) {
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)parkingLotIds)) {
            codition.setParkingLotInfIdIn(parkingLotIds);
        }
        Pager pager = this.parkWorkRecordService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_leftMenu_shiftRecord", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"park:workRecord:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        ParkWorkRecordItem parkWorkRecordItem = new ParkWorkRecordItem();
        this.setConditionValue((BaseItem)parkWorkRecordItem);
        List itemList = this.parkWorkRecordService.getItemData(ParkWorkRecordItem.class, parkWorkRecordItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, ParkWorkRecordItem.class);
    }
}

