/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.park.remote.ParkTransactionRemote;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingLotService;
import com.zkteco.zkbiosecurity.park.service.ParkTransactionService;
import com.zkteco.zkbiosecurity.park.vo.ParkTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkTransactionController
extends ExportController
implements ParkTransactionRemote {
    @Autowired
    private ParkTransactionService parkTransactionService;
    @Autowired
    private ParkParkingLotService parkParkingLotService;
    @Autowired
    private ParkParamsService parkParamsService;

    @RequiresPermissions(value={"park:transaction"})
    public ModelAndView index() {
        String isShowLotInfName = "true";
        if (!"zkteco-park".equals(this.parkParamsService.getParkingLotCommMode())) {
            isShowLotInfName = "false";
            this.request.setAttribute("showColumns", (Object)"!parkingLotInfName");
        }
        this.request.setAttribute("isShowLotInfName", (Object)isShowLotInfName);
        return new ModelAndView("park/transaction/parkTransaction");
    }

    @RequiresPermissions(value={"park:transaction:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkTransactionService.getItemById(id));
        }
        return new ModelAndView("park/transaction/editParkTransaction");
    }

    public DxGrid list(ParkTransactionItem codition) {
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)parkingLotIds)) {
            codition.setParkingLotInfIdIn(parkingLotIds);
        }
        Pager pager = this.parkTransactionService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, codition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"park:levelRecord:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        ParkTransactionItem parkTransactionItem = new ParkTransactionItem();
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)parkingLotIds)) {
            parkTransactionItem.setParkingLotInfIdIn(parkingLotIds);
        }
        this.setConditionValue((BaseItem)parkTransactionItem);
        List itemList = this.parkTransactionService.getItemData(parkTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, ParkTransactionItem.class);
    }
}

