/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.park.bean.ParkCheckOutInfo;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.remote.ParkRecordinRemote;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingLotService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkRecordinController
extends ExportController
implements ParkRecordinRemote {
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkParkingLotService parkParkingLotService;
    @Autowired(required=false)
    private BaseDictionaryValueService baseDictionaryValueService;

    @RequiresPermissions(value={"park:recordin"})
    public ModelAndView index() {
        StringBuffer showColumns = new StringBuffer("!releaseReason");
        if (this.parkParamsService.isLprCamera() && this.parkParamsService.isChineseLanguage()) {
            showColumns.append(",cardNumber");
        }
        String isShowLotInfName = "true";
        if (!"zkteco-park".equals(this.parkParamsService.getParkingLotCommMode())) {
            isShowLotInfName = "false";
            showColumns.append(",parkingLotInfName");
        }
        this.request.setAttribute("isShowLotInfName", (Object)isShowLotInfName);
        this.request.setAttribute("showColumns", (Object)showColumns);
        return new ModelAndView("park/recordin/parkRecordin");
    }

    @RequiresPermissions(value={"park:recordin:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkRecordinService.getItemById(id));
        }
        return new ModelAndView("park/recordin/editParkRecordin");
    }

    @RequiresPermissions(value={"park:recordin:edit"})
    public ZKResultMsg save(ParkRecordinItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkRecordinService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(ParkRecordinItem codition) {
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)parkingLotIds)) {
            codition.setParkingLotInfIdIn(parkingLotIds);
        }
        codition.setStatus(ParkConstants.CAR_STATUS_IN);
        Pager pager = this.parkRecordinService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkRecordinService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg manualReleaseIn(ParkCheckOutInfo parkCheckOutInfo) {
        this.parkRecordinService.manualReleaseIn(parkCheckOutInfo, ParkConstants.PAVILIO_WEB);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg confirmIn(ParkCheckOutInfo parkCheckOutInfo) {
        this.parkRecordinService.confirmIn(parkCheckOutInfo);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getPhotoByRecordinId(@RequestParam(value="recordinId") String recordinId) {
        String photo = this.parkRecordinService.getPhotoByRecordinId(recordinId);
        return new ZKResultMsg((Object)photo);
    }

    public ZKResultMsg getPhotoByParkingMeterId(@RequestParam(value="parkingMeterId", required=false) String parkingMeterId) {
        String photo = this.parkRecordinService.getPhotoByParkingMeterId(parkingMeterId);
        return new ZKResultMsg((Object)photo);
    }

    public ZKResultMsg searchRecordinInfo(ParkCheckOutInfo parkCheckOutInfo) {
        List parkRecordinItemList = this.parkRecordinService.searchRecordinInfo(parkCheckOutInfo);
        return new ZKResultMsg((Object)parkRecordinItemList);
    }

    @LogRequest(module="park_module", object="park_leftMenu_floorVehicleReport", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"park:recordin:export"})
    public void parkRecordinExport(HttpServletRequest request, HttpServletResponse response) {
        ParkRecordinItem parkRecordinItem = new ParkRecordinItem();
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)parkingLotIds)) {
            parkRecordinItem.setParkingLotInfIdIn(parkingLotIds);
        }
        parkRecordinItem.setStatus(ParkConstants.CAR_STATUS_IN);
        this.setConditionValue((BaseItem)parkRecordinItem);
        List itemList = this.parkRecordinService.getItemData(parkRecordinItem, this.getBeginIndex(), this.getEndIndex());
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put("channelState", this.baseDictionaryValueService.getDictionaryValuesMap("parkChannelState"));
        map.put("eventType", this.baseDictionaryValueService.getDictionaryValuesMap("parkEventType"));
        map.put("photoPathIn", this.parkRecordinService.converPhotoMap());
        this.excelExport(itemList, ParkRecordinItem.class, map);
    }

    public ZKResultMsg getByCardNumber(@RequestParam(value="cardNumber") String cardNumber) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        ParkRecordinItem parkRecordinItem = this.parkRecordinService.getByCardNumber(cardNumber);
        zkResultMsg.setData((Object)parkRecordinItem);
        return zkResultMsg;
    }

    public ZKResultMsg isExistPass(String cardNumber, String channelState) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        boolean isExistPass = this.parkRecordinService.isExistPass(cardNumber, channelState);
        zkResultMsg.setData((Object)isExistPass);
        return zkResultMsg;
    }

    public ZKResultMsg searchManualInfo(String carNumber) {
        List parkRecordinItemList = this.parkRecordinService.searchManualInfo(carNumber);
        return new ZKResultMsg((Object)parkRecordinItemList);
    }

    public ZKResultMsg manual(String carNumber, String recordinId) {
        String result = this.parkRecordinService.manual(carNumber, recordinId);
        if (result != null) {
            return ZKResultMsg.getFailMsg((String)result);
        }
        return ZKResultMsg.successMsg();
    }

    public ModelAndView stayTimeout() {
        StringBuffer showColumns = new StringBuffer("!releaseReason");
        if (this.parkParamsService.isLprCamera()) {
            showColumns.append(",cardNumber");
        }
        String isShowLotInfName = "true";
        if (!"zkteco-park".equals(this.parkParamsService.getParkingLotCommMode())) {
            isShowLotInfName = "false";
            showColumns.append(",parkingLotInfName");
        }
        this.request.setAttribute("isShowLotInfName", (Object)isShowLotInfName);
        this.request.setAttribute("showColumns", (Object)showColumns);
        return new ModelAndView("park/recordin/parkRecordinStayTimeout");
    }

    public DxGrid stayTimeoutList(ParkRecordinItem codition) {
        Date delayDate;
        codition.setStatus(ParkConstants.CAR_STATUS_IN);
        String dayOrHour = this.parkParamsService.getDayOrHour();
        int longTime = this.parkParamsService.getNotAppearDay();
        if ("day".equals(dayOrHour)) {
            delayDate = DateUtil.getDateBefore((Date)new Date(), (int)longTime);
            codition.setTimeEnd(delayDate);
        } else {
            delayDate = DateUtil.addHour((Date)new Date(), (int)(-longTime));
            codition.setTimeEnd(delayDate);
        }
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)parkingLotIds)) {
            codition.setParkingLotInfIdIn(parkingLotIds);
        }
        Pager pager = this.parkRecordinService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }
}

