/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.remote.ParkPavilioRemote;
import com.zkteco.zkbiosecurity.park.service.ParkChannelService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingLotService;
import com.zkteco.zkbiosecurity.park.service.ParkPavilioService;
import com.zkteco.zkbiosecurity.park.utils.ParkGetLocalIpAddrUtil;
import com.zkteco.zkbiosecurity.park.utils.ParkI18nUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkChannelItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPavilioItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkPavilioController
extends BaseController
implements ParkPavilioRemote {
    @Autowired
    private ParkPavilioService parkPavilioService;
    @Autowired
    private ParkChannelService parkChannelService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkParkingLotService parkParkingLotService;

    @RequiresPermissions(value={"park:pavilio"})
    public ModelAndView index() {
        if (!"zkteco-park".equals(this.parkParamsService.getParkingLotCommMode())) {
            this.request.setAttribute("showColumns", (Object)"!parkingLotInfName,communicationFlag");
        }
        return new ModelAndView("park/pavilio/parkPavilio");
    }

    @RequiresPermissions(value={"park:pavilio:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            ParkPavilioItem parkPavilioItem = this.parkPavilioService.getItemById(id);
            this.request.setAttribute("item", (Object)parkPavilioItem);
            if (ParkConstants.PAVILIO_CS.equals(parkPavilioItem.getClientMode())) {
                List parkChannelItemList = this.parkChannelService.getByPavilioId(id);
                int parkChannelCount = CollectionUtils.isNotEmpty((Collection)parkChannelItemList) ? parkChannelItemList.size() : 0;
                this.request.setAttribute("parkChannelCount", (Object)parkChannelCount);
            }
        }
        String parkingLotCommMode = this.parkParamsService.getParkingLotCommMode();
        this.request.setAttribute("disableCommMode", (Object)"false");
        this.request.setAttribute("parkingLotCommMode", (Object)parkingLotCommMode);
        if ("zkteco-park".equals(parkingLotCommMode)) {
            this.request.setAttribute("disableCommMode", (Object)"disable");
        }
        this.request.setAttribute("localIpAddress", (Object)ParkGetLocalIpAddrUtil.getClientIpAddr(this.request));
        return new ModelAndView("park/pavilio/editParkPavilio");
    }

    @RequiresPermissions(value={"park:pavilio:edit"})
    @LogRequest(module="park_module", object="park_pavilio", opType="park_pavilio_edit", requestParams={"name"}, opContent="park_pavilio_name")
    public ZKResultMsg save(ParkPavilioItem item) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemtList = this.parkPavilioService.saveItem(item, this.request.getSession().getId());
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemtList));
        return res;
    }

    @RequiresPermissions(value={"park:pavilio:refresh"})
    public DxGrid list(ParkPavilioItem codition) {
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)parkingLotIds)) {
            codition.setParkingLotInfIdIn(parkingLotIds);
        }
        Pager pager = this.parkPavilioService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_pavilio", opType="park_pavilio_del", requestParams={"names"}, opContent="park_pavilio_name")
    @RequiresPermissions(value={"park:pavilio:del"})
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkPavilioService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="park_module", object="park_pavilio", opType="park_pavilio_reset", requestParams={"names"}, opContent="park_pavilio_name")
    @RequiresPermissions(value={"park:pavilio:reset"})
    public ZKResultMsg reset(String ids) {
        this.parkPavilioService.reset(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getAllPavilio() {
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(this.request.getSession().getId());
        List selectItems = StringUtils.isBlank((CharSequence)parkingLotIds) ? this.parkPavilioService.getAllPavilio() : this.parkPavilioService.getAllPavilioList(parkingLotIds);
        return new ZKResultMsg((Object)selectItems);
    }

    public boolean isNotExist(@RequestParam(value="name", required=false) String name) {
        return this.parkPavilioService.isNotExist(name);
    }

    public boolean isNotExistIP(@RequestParam(value="ipAddress", required=false) String ipAddress) {
        return this.parkPavilioService.isNotExistIP(ipAddress);
    }

    public boolean isNotExistCode(@RequestParam(value="registrationCode", required=false) String registrationCode) {
        return this.parkPavilioService.isNotExistCode(registrationCode);
    }

    public ZKResultMsg getAvoptionByEditAndOther(@RequestParam(value="pavilioId", required=false) String pavilioId, @RequestParam(value="editAvoption", required=false) String editAvoption, @RequestParam(value="otherAvoption", required=false) String otherAvoption) {
        List selectItems = this.parkPavilioService.getAvoptionByEditAndOther(pavilioId, editAvoption, otherAvoption);
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg getAvoptionByEditAndOtherAccModel(String pavilioId, String editAvoption, String otherAvoption) {
        List selectItems = this.parkPavilioService.getAvoptionByEditAndOtherAccModel(pavilioId, editAvoption, otherAvoption);
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg checkShowLimitLineMode() {
        ZKResultMsg resultMsg = new ZKResultMsg();
        ParkPavilioItem parkPavilioItem = this.parkPavilioService.getPavilioByIpAddress(ParkGetLocalIpAddrUtil.getClientIpAddr(this.request));
        if (Objects.nonNull(parkPavilioItem)) {
            List parkChannelItemList = this.parkChannelService.getByPavilioId(parkPavilioItem.getId());
            if (CollectionUtils.isEmpty((Collection)parkChannelItemList)) {
                resultMsg.setData((Object)I18nUtil.i18nCode((String)"park_terminalManagement_noChannel", (Object[])new Object[0]));
            } else {
                boolean isSetRestrictType = false;
                for (ParkChannelItem parkChannelItem : parkChannelItemList) {
                    if (!StringUtils.isNotEmpty((CharSequence)parkChannelItem.getRestrictVehicleType())) continue;
                    isSetRestrictType = true;
                    break;
                }
                if (!isSetRestrictType) {
                    resultMsg.setData((Object)I18nUtil.i18nCode((String)"park_terminalManagement_channelNoRestrictType", (Object[])new Object[0]));
                }
            }
        } else {
            resultMsg.setData((Object)I18nUtil.i18nCode((String)"park_terminalManagement_noPavilio", (Object[])new Object[0]));
        }
        return resultMsg;
    }

    public ZKResultMsg checkNormallyOpen() {
        ZKResultMsg resultMsg = new ZKResultMsg();
        ParkPavilioItem parkPavilioItem = this.parkPavilioService.getPavilioByIpAddress(ParkGetLocalIpAddrUtil.getClientIpAddr(this.request));
        if (Objects.nonNull(parkPavilioItem)) {
            List parkChannelItemList = this.parkChannelService.getByPavilioId(parkPavilioItem.getId());
            if (CollectionUtils.isEmpty((Collection)parkChannelItemList)) {
                resultMsg.setData((Object)I18nUtil.i18nCode((String)"park_terminalManagement_noChannel", (Object[])new Object[0]));
            }
        } else {
            resultMsg.setData((Object)I18nUtil.i18nCode((String)"park_terminalManagement_noPavilio", (Object[])new Object[0]));
        }
        return resultMsg;
    }

    public TreeItem getPavilioTree() {
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(this.request.getSession().getId());
        List treeItems = StringUtils.isBlank((CharSequence)parkingLotIds) ? this.parkPavilioService.getPavilioTree() : this.parkPavilioService.getPavilioTreeList(parkingLotIds);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getAllPavilioByArea(@RequestParam(value="parkingAreaId") String parkingAreaId) {
        List selectItems = this.parkPavilioService.getAllPavilioByArea(parkingAreaId);
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg isExistCSClient() {
        boolean isExist = this.parkPavilioService.isExistCSClient();
        return new ZKResultMsg((Object)isExist);
    }
}

